/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbSession;
import jcifs.spnego.AuthenticationException;
import jcifs.spnego.NegTokenInit;
import jcifs.spnego.NegTokenTarg;
import jcifs.spnego.SpnegoToken;
import jcifs.spnego.UnsupportedMechanismException;

public class Authentication {
    private static final byte[] NTLMSSP_SIGNATURE = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private static final boolean KERBEROS_SUPPORTED = Authentication.getKerberosSupport();
    private Properties properties = new Properties();
    private boolean client;
    private byte[] nextToken;
    private Object subject;
    private Principal principal;
    private Object context;
    private static Object kerberosOid;
    private static Method getGssInstance;
    private static Method createName;
    private static Method createCredential;
    private static Method createInitiateContext;
    private static Method createAcceptContext;
    private static Method initSecContext;
    private static Method acceptSecContext;
    private static Method getSrcName;
    private static Method getCredDelegState;
    private static Method getMutualAuthState;
    private static Method getReplayDetState;
    private static Method getSequenceDetState;
    private static Method getAnonymityState;
    private static Method getConfState;
    private static Method getIntegState;
    private static Method isEstablished;
    private static Class callbackHandler;
    private static Constructor newKerberosPrincipal;
    private static Constructor newLoginContext;
    private static Method login;
    private static Method getSubject;
    private static Method doAsPrivileged;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$PrivilegedExceptionAction;
    static /* synthetic */ Class class$java$security$AccessControlContext;
    static /* synthetic */ Class array$C;

    public Authentication() {
        this(null);
    }

    public Authentication(Properties properties) {
        this.setProperties(properties);
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public String getProperty(String property) {
        String value = this.getProperties().getProperty(property);
        if (value == null) {
            value = Config.getProperty((String)property);
        }
        return value != null ? value : System.getProperty(property);
    }

    public void setProperty(String property, String value) {
        if (value != null) {
            this.getProperties().setProperty(property, value);
        } else {
            this.getProperties().remove(property);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(String[] mechanisms) throws AuthenticationException {
        this.reset();
        this.client = true;
        if (mechanisms == null || mechanisms.length == 0) {
            String unicode = this.getProperty("jcifs.smb.client.useUnicode");
            boolean useUnicode = unicode != null ? Boolean.valueOf(unicode) : true;
            int flags = 0x200 | (useUnicode ? 1 : 2);
            String domain = this.getProperty("jcifs.smb.client.domain");
            String workstation = null;
            try {
                workstation = NbtAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            this.nextToken = new Type1Message(flags, domain, workstation).toByteArray();
            return;
        }
        int contextFlags = 0;
        byte[] mechanismToken = null;
        String initialMechanism = mechanisms[0];
        if ("1.3.6.1.4.1.311.2.2.10".equals(initialMechanism)) {
            String unicode = this.getProperty("jcifs.smb.client.useUnicode");
            boolean useUnicode = unicode != null ? Boolean.valueOf(unicode) : true;
            int flags = 0x200 | (useUnicode ? 1 : 2);
            String domain = this.getProperty("jcifs.smb.client.domain");
            String workstation = null;
            try {
                workstation = NbtAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            mechanismToken = new Type1Message(flags, domain, workstation).toByteArray();
        } else {
            boolean subjectOnly;
            if (!"1.2.840.113554.1.2.2".equals(initialMechanism) && !"1.2.840.48018.1.2.2".equals(initialMechanism)) throw new UnsupportedMechanismException("Unsupported initial mechanism: " + initialMechanism);
            ClientAction action = new ClientAction(null);
            String useSubjectCredsOnly = this.getProperty("javax.security.auth.useSubjectCredsOnly");
            boolean bl = subjectOnly = useSubjectCredsOnly == null ? true : Boolean.valueOf(useSubjectCredsOnly);
            if (subjectOnly) {
                try {
                    String name = this.getProperty("javax.security.auth.login.name");
                    String password = this.getProperty("javax.security.auth.login.password");
                    Object loginContext = newLoginContext.newInstance("jcifs.spnego.initiate", Authentication.createLoginHandler(name, password));
                    login.invoke(loginContext, null);
                    this.subject = getSubject.invoke(loginContext, null);
                }
                catch (Exception ex) {
                    throw new AuthenticationException("Unable to login: " + ex, ex);
                }
            }
            try {
                mechanismToken = (byte[])(this.subject != null ? doAsPrivileged.invoke(null, this.subject, action, null) : action.run());
            }
            catch (Exception ex) {
                throw new AuthenticationException("Error processing token: " + ex, ex);
            }
            try {
                if (((Boolean)getCredDelegState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 0x40;
                }
                if (((Boolean)getMutualAuthState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 0x20;
                }
                if (((Boolean)getReplayDetState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 0x10;
                }
                if (((Boolean)getSequenceDetState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 8;
                }
                if (((Boolean)getAnonymityState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 4;
                }
                if (((Boolean)getConfState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 2;
                }
                if (((Boolean)getIntegState.invoke(this.context, null)).booleanValue()) {
                    contextFlags |= 1;
                }
            }
            catch (Exception ex) {
                throw new AuthenticationException(ex.getMessage());
            }
        }
        this.nextToken = new NegTokenInit(mechanisms, contextFlags, mechanismToken, null).toByteArray();
    }

    public void reset() {
        this.client = false;
        this.nextToken = null;
        this.subject = null;
        this.principal = null;
        this.context = null;
    }

    public void process(byte[] token) throws AuthenticationException {
        if (token == null) {
            throw new NullPointerException("Null token.");
        }
        if (this.getPrincipal() != null) {
            throw new IllegalStateException("Context already completed.");
        }
        if (Authentication.isNtlm(token)) {
            this.processNtlm(token);
        } else {
            this.processSpnego(token);
        }
    }

    private UniAddress getDomainController() throws UnknownHostException {
        boolean loadBalance = false;
        String domainController = this.getProperty("jcifs.http.domainController");
        if (domainController == null) {
            domainController = this.getProperty("jcifs.smb.client.domain");
            String balance = this.getProperty("jcifs.http.loadBalance");
            loadBalance = balance != null ? Boolean.valueOf(balance) : true;
        }
        return loadBalance ? new UniAddress((Object)NbtAddress.getByName((String)domainController, (int)28, null)) : UniAddress.getByName((String)domainController, (boolean)true);
    }

    private void processNtlm(byte[] token) throws AuthenticationException {
        byte[] challenge = null;
        try {
            switch (token[8]) {
                case 1: {
                    if (this.client) {
                        throw new AuthenticationException("NTLM Type 1 message received by client.");
                    }
                    challenge = SmbSession.getChallenge((UniAddress)this.getDomainController());
                    this.nextToken = new Type2Message(new Type1Message(token), challenge, null).toByteArray();
                    break;
                }
                case 2: {
                    if (!this.client) {
                        throw new AuthenticationException("NTLM Type 2 message received by server.");
                    }
                    String workstation = null;
                    try {
                        workstation = NbtAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException ex) {
                        // empty catch block
                    }
                    this.nextToken = new Type3Message(new Type2Message(token), this.getProperty("jcifs.smb.client.password"), this.getProperty("jcifs.smb.client.domain"), this.getProperty("jcifs.smb.client.username"), workstation).toByteArray();
                    break;
                }
                case 3: {
                    byte[] ntResponse;
                    if (this.client) {
                        throw new AuthenticationException("NTLM Type 3 message received by client.");
                    }
                    Type3Message type3 = new Type3Message(token);
                    byte[] lmResponse = type3.getLMResponse();
                    if (lmResponse == null) {
                        lmResponse = new byte[]{};
                    }
                    if ((ntResponse = type3.getNTResponse()) == null) {
                        ntResponse = new byte[]{};
                    }
                    this.nextToken = null;
                    challenge = SmbSession.getChallenge((UniAddress)this.getDomainController());
                    NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
                    SmbSession.logon((UniAddress)this.getDomainController(), (NtlmPasswordAuthentication)auth);
                    this.principal = auth;
                    break;
                }
                default: {
                    throw new AuthenticationException("Unrecognized NTLM Token Type: " + token[8]);
                }
            }
        }
        catch (AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationException("Error performing NTLM authentication: " + ex, ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSpnego(byte[] token) throws AuthenticationException {
        try {
            void var4_7;
            String mechanism;
            SpnegoToken spnegoToken;
            switch (token[0]) {
                case 96: {
                    NegTokenInit initToken = new NegTokenInit(token);
                    spnegoToken = initToken;
                    byte[] mechanismToken = initToken.getMechanismToken();
                    mechanism = mechanismToken != null ? initToken.getMechanisms()[0] : null;
                    break;
                }
                case -95: {
                    NegTokenTarg targToken = new NegTokenTarg(token);
                    spnegoToken = targToken;
                    byte[] mechanismToken = targToken.getMechanismToken();
                    mechanism = targToken.getMechanism();
                    break;
                }
                default: {
                    throw new AuthenticationException("Unrecognized SPNEGO Token.");
                }
            }
            if (Authentication.isNtlm((byte[])var4_7)) {
                this.processNtlm((byte[])var4_7);
                if (this.nextToken == null) {
                    return;
                }
                int result = this.getPrincipal() == null ? 1 : 0;
                this.nextToken = new NegTokenTarg(result, "1.3.6.1.4.1.311.2.2.10", this.nextToken, null).toByteArray();
            } else if (mechanism != null && KERBEROS_SUPPORTED) {
                this.processKerberos(mechanism, (byte[])var4_7);
            } else {
                if (!(spnegoToken instanceof NegTokenInit)) {
                    this.nextToken = new NegTokenTarg(2, null, null, null).toByteArray();
                    return;
                }
                String[] mechanisms = ((NegTokenInit)spnegoToken).getMechanisms();
                if (mechanisms == null) {
                    this.nextToken = new NegTokenTarg(2, null, null, null).toByteArray();
                    return;
                }
                List<String> mechList = Arrays.asList(mechanisms);
                mechanism = KERBEROS_SUPPORTED ? (mechList.contains("1.2.840.113554.1.2.2") ? "1.2.840.113554.1.2.2" : (mechList.contains("1.2.840.48018.1.2.2") ? "1.2.840.48018.1.2.2" : "1.3.6.1.4.1.311.2.2.10")) : "1.3.6.1.4.1.311.2.2.10";
                this.nextToken = mechList.contains(mechanism) ? new NegTokenTarg(1, mechanism, null, null).toByteArray() : new NegTokenTarg(2, null, null, null).toByteArray();
            }
        }
        catch (AuthenticationException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AuthenticationException("Error performing SPNEGO negotiation: " + ex, ex);
        }
    }

    private void processKerberos(String mechanism, byte[] token) throws AuthenticationException {
        try {
            if (this.client) {
                int result;
                ClientAction action = new ClientAction(token);
                token = (byte[])(this.subject != null ? doAsPrivileged.invoke(null, this.subject, action, null) : action.run());
                if (((Boolean)isEstablished.invoke(this.context, null)).booleanValue()) {
                    result = 0;
                    this.principal = (Principal)newKerberosPrincipal.newInstance(getSrcName.invoke(this.context, null).toString());
                } else {
                    result = 1;
                }
                this.nextToken = new NegTokenTarg(result, mechanism, token, null).toByteArray();
            } else {
                int result;
                ServerAction action = new ServerAction(token);
                if (this.subject == null) {
                    boolean subjectOnly;
                    String useSubjectCredsOnly = this.getProperty("javax.security.auth.useSubjectCredsOnly");
                    boolean bl = subjectOnly = useSubjectCredsOnly == null ? true : Boolean.valueOf(useSubjectCredsOnly);
                    if (subjectOnly) {
                        String name = this.getProperty("jcifs.spnego.servicePrincipal");
                        String password = this.getProperty("jcifs.spnego.servicePassword");
                        Object loginContext = newLoginContext.newInstance("jcifs.spnego.accept", Authentication.createLoginHandler(name, password));
                        login.invoke(loginContext, null);
                        this.subject = getSubject.invoke(loginContext, null);
                    }
                }
                token = (byte[])(this.subject != null ? doAsPrivileged.invoke(null, this.subject, action, null) : action.run());
                if (((Boolean)isEstablished.invoke(this.context, null)).booleanValue()) {
                    result = 0;
                    this.principal = (Principal)newKerberosPrincipal.newInstance(getSrcName.invoke(this.context, null).toString());
                } else {
                    result = 1;
                }
                this.nextToken = new NegTokenTarg(result, mechanism, token, null).toByteArray();
            }
        }
        catch (Exception ex) {
            throw new AuthenticationException("Error performing Kerberos authentication: " + ex, ex);
        }
    }

    private static boolean isNtlm(byte[] token) {
        if (token == null || token.length < 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (NTLMSSP_SIGNATURE[i] == token[i]) continue;
            return false;
        }
        return true;
    }

    private static Object createLoginHandler(String name, String password) {
        return Proxy.newProxyInstance(callbackHandler.getClassLoader(), new Class[]{callbackHandler}, (InvocationHandler)new SpnegoLoginHandler(name, password));
    }

    private static boolean getKerberosSupport() {
        try {
            Class<?> gss = Class.forName("org.ietf.jgss.GSSManager");
            getGssInstance = gss.getMethod("getInstance", null);
            Object manager = getGssInstance.invoke(null, null);
            Object[] mechs = (Object[])gss.getMethod("getMechs", null).invoke(manager, null);
            if (mechs == null) {
                return false;
            }
            for (int i = mechs.length - 1; i >= 0; --i) {
                if (!"1.2.840.113554.1.2.2".equals(mechs[i].toString())) continue;
                kerberosOid = mechs[i];
                Class<?> oidClass = Class.forName("org.ietf.jgss.Oid");
                createName = gss.getMethod("createName", class$java$lang$String == null ? (class$java$lang$String = Authentication.class$("java.lang.String")) : class$java$lang$String, oidClass);
                Class<?> nameClass = Class.forName("org.ietf.jgss.GSSName");
                createCredential = gss.getMethod("createCredential", nameClass, Integer.TYPE, oidClass, Integer.TYPE);
                Class<?> credentialClass = Class.forName("org.ietf.jgss.GSSCredential");
                createInitiateContext = gss.getMethod("createContext", nameClass, oidClass, credentialClass, Integer.TYPE);
                createAcceptContext = gss.getMethod("createContext", credentialClass);
                Class<?> contextClass = Class.forName("org.ietf.jgss.GSSContext");
                initSecContext = contextClass.getMethod("initSecContext", array$B == null ? (array$B = Authentication.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE);
                acceptSecContext = contextClass.getMethod("acceptSecContext", array$B == null ? (array$B = Authentication.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE);
                getSrcName = contextClass.getMethod("getSrcName", null);
                getCredDelegState = contextClass.getMethod("getCredDelegState", null);
                getMutualAuthState = contextClass.getMethod("getMutualAuthState", null);
                getReplayDetState = contextClass.getMethod("getReplayDetState", null);
                getSequenceDetState = contextClass.getMethod("getSequenceDetState", null);
                getAnonymityState = contextClass.getMethod("getAnonymityState", null);
                getConfState = contextClass.getMethod("getConfState", null);
                getIntegState = contextClass.getMethod("getIntegState", null);
                isEstablished = contextClass.getMethod("isEstablished", null);
                Class<?> loginContext = Class.forName("javax.security.auth.login.LoginContext");
                callbackHandler = Class.forName("javax.security.auth.callback.CallbackHandler");
                newLoginContext = loginContext.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Authentication.class$("java.lang.String")) : class$java$lang$String, callbackHandler);
                Class<?> kerberosPrincipal = Class.forName("javax.security.auth.kerberos.KerberosPrincipal");
                newKerberosPrincipal = kerberosPrincipal.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Authentication.class$("java.lang.String")) : class$java$lang$String);
                login = loginContext.getMethod("login", null);
                getSubject = loginContext.getMethod("getSubject", null);
                Class<?> subjectClass = Class.forName("javax.security.auth.Subject");
                doAsPrivileged = subjectClass.getMethod("doAsPrivileged", subjectClass, class$java$security$PrivilegedExceptionAction == null ? (class$java$security$PrivilegedExceptionAction = Authentication.class$("java.security.PrivilegedExceptionAction")) : class$java$security$PrivilegedExceptionAction, class$java$security$AccessControlContext == null ? (class$java$security$AccessControlContext = Authentication.class$("java.security.AccessControlContext")) : class$java$security$AccessControlContext);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SpnegoLoginHandler
    implements InvocationHandler {
        private final String username;
        private final String password;

        public SpnegoLoginHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!"handle".equals(method.getName())) {
                throw new UnsupportedOperationException(method.getName());
            }
            Object[] callbacks = (Object[])args[0];
            Class<?> nameCallback = Class.forName("javax.security.auth.callback.NameCallback");
            Method setName = nameCallback.getMethod("setName", class$java$lang$String == null ? (class$java$lang$String = Authentication.class$("java.lang.String")) : class$java$lang$String);
            Class<?> passwordCallback = Class.forName("javax.security.auth.callback.PasswordCallback");
            Method setPassword = passwordCallback.getMethod("setPassword", array$C == null ? (array$C = Authentication.class$("[C")) : array$C);
            for (int i = 0; i < callbacks.length; ++i) {
                Object callback = callbacks[i];
                if (nameCallback.isInstance(callback)) {
                    setName.invoke(callback, this.username);
                }
                if (!passwordCallback.isInstance(callback)) continue;
                setPassword.invoke(callback, new Object[]{this.password != null ? this.password.toCharArray() : null});
            }
            return null;
        }
    }

    private class ServerAction
    implements PrivilegedExceptionAction {
        private byte[] token;

        public ServerAction(byte[] token) {
            this.token = token != null ? token : new byte[]{};
        }

        public Object run() throws Exception {
            if (Authentication.this.context == null) {
                Object gss = getGssInstance.invoke(null, null);
                Object servicePrincipal = createName.invoke(gss, Authentication.this.getProperty("jcifs.spnego.servicePrincipal"), null);
                Object credential = createCredential.invoke(gss, servicePrincipal, new Integer(0), kerberosOid, new Integer(2));
                Authentication.this.context = createAcceptContext.invoke(gss, credential);
            }
            return acceptSecContext.invoke(Authentication.this.context, this.token, new Integer(0), new Integer(this.token.length));
        }
    }

    private class ClientAction
    implements PrivilegedExceptionAction {
        private byte[] token;

        public ClientAction(byte[] token) {
            this.token = token != null ? token : new byte[]{};
        }

        public Object run() throws Exception {
            if (Authentication.this.context == null) {
                Object gss = getGssInstance.invoke(null, null);
                Object servicePrincipal = createName.invoke(gss, Authentication.this.getProperty("jcifs.spnego.servicePrincipal"), null);
                Object credential = null;
                String user = Authentication.this.getProperty("javax.security.auth.login.name");
                if (user != null) {
                    Object userName = createName.invoke(gss, user, null);
                    credential = createCredential.invoke(gss, userName, new Integer(0), kerberosOid, new Integer(1));
                }
                Authentication.this.context = createInitiateContext.invoke(gss, servicePrincipal, kerberosOid, credential, new Integer(0));
            }
            return initSecContext.invoke(Authentication.this.context, this.token, new Integer(0), new Integer(this.token.length));
        }
    }
}

