/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.user;

import java.lang.reflect.Constructor;
import java.security.Key;
import java.util.Random;
import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.util.DES;

public class SamOemChangePassword
extends Operation {
    private static final boolean ARC4_SUPPORT = SamOemChangePassword.getArc4Support();
    private static final int SAM_OEM_CHANGE_PASSWORD = 214;
    private static final Random RANDOM = new Random();
    private static final byte[] S8 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private String user;
    private String oldPassword;
    private String newPassword;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$Key;

    public SamOemChangePassword(String user, String oldPassword, String newPassword) {
        if (!ARC4_SUPPORT) {
            throw new UnsupportedOperationException("SamOemChangePassword is not supported: ARC4 not found.");
        }
        this.user = user;
        this.oldPassword = oldPassword;
        this.newPassword = newPassword;
        this.setNumber(214);
        this.setParameterDescriptor("zsT");
        this.setDataDescriptor("B516B16");
        this.setMaxParameterLength(4);
        this.setMaxDataLength(0);
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeString(this.user);
        buffer.writeShort(532L);
    }

    public void writeRequestData(Buffer buffer) {
        try {
            byte[] passwordBytes = this.newPassword.getBytes(Buffer.ENCODING);
            int passwordLength = passwordBytes.length;
            if (passwordLength > 512) {
                throw new IndexOutOfBoundsException("Password too long.");
            }
            byte[] data = new byte[532];
            RANDOM.nextBytes(data);
            System.arraycopy(passwordBytes, 0, data, 512 - passwordLength, passwordLength);
            new Buffer(data, 512).writeLong(passwordLength);
            byte[] oldHash = SamOemChangePassword.hash(this.oldPassword);
            SamOemChangePassword.arcFour(oldHash, data, 0, 516);
            byte[] newHash = SamOemChangePassword.hash(this.newPassword);
            byte[] key = new byte[7];
            byte[] value = new byte[8];
            System.arraycopy(newHash, 0, key, 0, 7);
            System.arraycopy(oldHash, 0, value, 0, 8);
            SamOemChangePassword.des(key, value, data, 516);
            System.arraycopy(newHash, 7, key, 0, 7);
            System.arraycopy(oldHash, 8, value, 0, 8);
            SamOemChangePassword.des(key, value, data, 524);
            System.arraycopy(data, 0, buffer.buffer, buffer.index, 532);
            buffer.index += 532;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    private static byte[] hash(String password) throws Exception {
        byte[] passwordBytes = password.toUpperCase().getBytes(Buffer.ENCODING);
        int passwordLength = passwordBytes.length;
        if (passwordLength > 14) {
            passwordLength = 14;
        }
        byte[] pwd = new byte[14];
        System.arraycopy(passwordBytes, 0, pwd, 0, passwordLength);
        byte[] hash = new byte[16];
        SamOemChangePassword.des(pwd, S8, hash, 0);
        return hash;
    }

    private static void des(byte[] key, byte[] value, byte[] dest, int index) {
        byte[] key7 = new byte[7];
        byte[] e8 = new byte[8];
        for (int i = 0; i < key.length / 7; ++i) {
            System.arraycopy(key, i * 7, key7, 0, 7);
            DES des = new DES(key7);
            des.encrypt(value, e8);
            System.arraycopy(e8, 0, dest, index + i * 8, 8);
        }
    }

    private static void arcFour(byte[] key, byte[] data, int index, int length) throws Exception {
        Class<?> cipher = Class.forName("javax.crypto.Cipher");
        Object arc4 = cipher.getMethod("getInstance", class$java$lang$String == null ? (class$java$lang$String = SamOemChangePassword.class$("java.lang.String")) : class$java$lang$String).invoke(null, "ARC4");
        Constructor<?> constructor = Class.forName("javax.crypto.spec.SecretKeySpec").getConstructor(key.getClass(), class$java$lang$String == null ? (class$java$lang$String = SamOemChangePassword.class$("java.lang.String")) : class$java$lang$String);
        Key secretKey = (Key)constructor.newInstance(key, "ARC4");
        cipher.getMethod("init", Integer.TYPE, class$java$security$Key == null ? (class$java$security$Key = SamOemChangePassword.class$("java.security.Key")) : class$java$security$Key).invoke(arc4, cipher.getField("ENCRYPT_MODE").get(null), secretKey);
        cipher.getMethod("doFinal", data.getClass(), Integer.TYPE, Integer.TYPE, data.getClass(), Integer.TYPE).invoke(arc4, data, new Integer(index), new Integer(length), data, new Integer(index));
    }

    private static boolean getArc4Support() {
        try {
            Class<?> cipher = Class.forName("javax.crypto.Cipher");
            Object arc4 = cipher.getMethod("getInstance", class$java$lang$String == null ? (class$java$lang$String = SamOemChangePassword.class$("java.lang.String")) : class$java$lang$String).invoke(null, "ARC4");
            System.out.println("arc4 IS AVAILABLE.");
            return true;
        }
        catch (Throwable t) {
            System.out.println("No arc4 support.");
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

