/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.session;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.session.SessionInfo;

public class NetSessionEnum
extends Operation {
    private static final int NET_SESSION_ENUM = 6;
    public SessionInfo[] sessions;
    private SessionInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetSessionEnum(SessionInfo infoTemplate) {
        this.infoTemplate = infoTemplate;
        this.setNumber(6);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("WrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.sessions = new SessionInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.sessions[i] = (SessionInfo)this.infoTemplate.clone();
            this.sessions[i].read(buffer);
        }
    }
}

