/*
 * Decompiled with CFR 0.152.
 */
package jcifs.rap.group;

import jcifs.rap.Buffer;
import jcifs.rap.Operation;
import jcifs.rap.group.GroupInfo;

public class NetGroupEnum
extends Operation {
    private static final int NET_GROUP_ENUM = 47;
    public GroupInfo[] groups;
    private GroupInfo infoTemplate;
    private int entryCount;
    private int availableBytes;

    public NetGroupEnum(GroupInfo infoTemplate) {
        this.infoTemplate = infoTemplate;
        this.setNumber(47);
        this.setMaxParameterLength(8);
        this.setParameterDescriptor("WrLeh");
        this.setDataDescriptor(infoTemplate.getDescriptor());
    }

    public void writeRequestParameters(Buffer buffer) {
        buffer.writeShort(this.infoTemplate.getLevel());
        buffer.writeShort(this.getMaxDataLength());
    }

    public void readResponseParameters(Buffer buffer) {
        this.entryCount = buffer.readShort();
        this.availableBytes = buffer.readShort();
    }

    public void readResponseData(Buffer buffer) {
        this.groups = new GroupInfo[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.groups[i] = (GroupInfo)this.infoTemplate.clone();
            this.groups[i].read(buffer);
        }
    }
}

