/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import jcifs.util.Base64;

public class Negotiate {
    public static Principal authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Principal principal;
        String auth = request.getHeader("Authorization");
        int index = auth.indexOf(32);
        String mechanism = auth.substring(0, index);
        byte[] token = Base64.decode((String)auth.substring(index).trim());
        Authentication authentication = new Authentication();
        try {
            authentication.process(token);
        }
        catch (AuthenticationException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                throw new ServletException(ex.getMessage());
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException(ex.getMessage(), ex.getCause());
        }
        byte[] nextToken = authentication.getNextToken();
        if (nextToken != null) {
            auth = Base64.encode((byte[])nextToken);
            response.setHeader("WWW-Authenticate", mechanism + " " + auth);
        }
        if ((principal = authentication.getPrincipal()) != null) {
            return principal;
        }
        response.setStatus(401);
        response.setContentLength(0);
        response.flushBuffer();
        return null;
    }
}

