/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.AuthenticatedRequest;
import jcifs.http.Negotiate;
import jcifs.netbios.NbtAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;

public class AuthenticationFilter
implements Filter {
    public static final String HTTP_NEGOTIATE = "Negotiate";
    public static final String HTTP_NTLM = "NTLM";
    public static final String HTTP_BASIC = "Basic";
    private FilterConfig filterConfig;
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private boolean enableNegotiate;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;

    public void init(FilterConfig filterConfig) throws ServletException {
        String krbKdc;
        String krbRealm;
        String krbConf;
        String useSubjectCredsOnly;
        this.filterConfig = filterConfig;
        Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)"300000");
        Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)"600");
        Enumeration parameters = filterConfig.getInitParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            if (!parameter.startsWith("jcifs.")) continue;
            Config.setProperty((String)parameter, (String)filterConfig.getInitParameter(parameter));
        }
        if (Boolean.valueOf(filterConfig.getInitParameter("sun.security.krb5.debug")).booleanValue()) {
            System.setProperty("sun.security.krb5.debug", "true");
        }
        String loginConfig = filterConfig.getInitParameter("java.security.auth.login.config");
        if (System.getProperty("java.security.auth.login.config") == null || loginConfig != null) {
            URL url;
            try {
                url = filterConfig.getServletContext().getResource(loginConfig == null ? "/WEB-INF/login.conf" : loginConfig);
                if (url != null) {
                    loginConfig = url.toExternalForm();
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (loginConfig != null) {
                System.setProperty("java.security.auth.login.config", loginConfig);
            } else {
                url = this.getClass().getResource("/jcifs/http/login.conf");
                if (url != null) {
                    System.setProperty("java.security.auth.login.config", url.toExternalForm());
                }
            }
        }
        if ((useSubjectCredsOnly = filterConfig.getInitParameter("javax.security.auth.useSubjectCredsOnly")) != null) {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", useSubjectCredsOnly);
        }
        if ((krbConf = filterConfig.getInitParameter("java.security.krb5.conf")) != null) {
            try {
                String realPath = filterConfig.getServletContext().getRealPath(krbConf);
                if (realPath != null && new File(realPath).isFile()) {
                    krbConf = realPath;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            System.setProperty("java.security.krb5.conf", krbConf);
        }
        if ((krbRealm = filterConfig.getInitParameter("java.security.krb5.realm")) != null) {
            System.setProperty("java.security.krb5.realm", krbRealm);
        }
        if ((krbKdc = filterConfig.getInitParameter("java.security.krb5.kdc")) != null) {
            System.setProperty("java.security.krb5.kdc", krbKdc);
        }
        this.defaultDomain = Config.getProperty((String)"jcifs.smb.client.domain");
        this.domainController = Config.getProperty((String)"jcifs.http.domainController");
        if (this.domainController == null) {
            this.domainController = this.defaultDomain;
            this.loadBalance = Config.getBoolean((String)"jcifs.http.loadBalance", (boolean)true);
        }
        this.enableNegotiate = Config.getBoolean((String)"jcifs.http.enableNegotiate", (boolean)false);
        this.enableBasic = Config.getBoolean((String)"jcifs.http.enableBasic", (boolean)false);
        this.insecureBasic = Config.getBoolean((String)"jcifs.http.insecureBasic", (boolean)false);
        this.realm = Config.getProperty((String)"jcifs.http.basicRealm");
        if (this.realm == null) {
            this.realm = "jCIFS";
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        try {
            this.init(filterConfig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean offerBasic;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Principal principal = null;
        String authType = null;
        String msg = req.getHeader("Authorization");
        boolean bl = offerBasic = this.enableBasic && (this.insecureBasic || req.isSecure());
        if (msg != null && (msg.regionMatches(true, 0, "Negotiate ", 0, 10) || msg.regionMatches(true, 0, "NTLM ", 0, 5) || offerBasic && msg.regionMatches(true, 0, "Basic ", 0, 6))) {
            authType = msg.regionMatches(true, 0, "Negotiate ", 0, 10) ? HTTP_NEGOTIATE : (msg.regionMatches(true, 0, "NTLM ", 0, 5) ? HTTP_NTLM : HTTP_BASIC);
            try {
                if (HTTP_NEGOTIATE.equals(authType) || HTTP_NTLM.equals(authType)) {
                    principal = Negotiate.authenticate(req, resp);
                    if (principal == null) {
                        return;
                    }
                    req.getSession().setAttribute("jcifs.http.principal", (Object)principal);
                    chain.doFilter((ServletRequest)new AuthenticatedRequest(req, principal, authType), (ServletResponse)resp);
                    return;
                }
                UniAddress dc = this.loadBalance ? new UniAddress((Object)NbtAddress.getByName((String)this.domainController, (int)28, null)) : UniAddress.getByName((String)this.domainController, (boolean)true);
                String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                principal = new NtlmPasswordAuthentication(domain, user, password);
                SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)((NtlmPasswordAuthentication)principal));
            }
            catch (SmbAuthException sae) {
                this.fail(sae.getNtStatus() == -1073741819, req, resp);
                return;
            }
            HttpSession ssn = req.getSession();
            ssn.setAttribute("jcifs.http.principal", (Object)principal);
        } else {
            HttpSession ssn = req.getSession(false);
            if (ssn == null || (principal = (Principal)ssn.getAttribute("jcifs.http.principal")) == null) {
                this.fail(false, req, resp);
                return;
            }
        }
        chain.doFilter((ServletRequest)new AuthenticatedRequest(req, principal, authType), (ServletResponse)resp);
    }

    private void fail(boolean clearSession, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession ssn;
        if (clearSession && (ssn = req.getSession(false)) != null) {
            ssn.removeAttribute("jcifs.http.principal");
        }
        if (this.enableNegotiate) {
            resp.addHeader("WWW-Authenticate", HTTP_NEGOTIATE);
        }
        resp.addHeader("WWW-Authenticate", HTTP_NTLM);
        if (this.enableBasic && (this.insecureBasic || req.isSecure())) {
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        }
        resp.setHeader("Connection", "close");
        resp.setStatus(401);
        resp.flushBuffer();
    }
}

