/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.security.Principal;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jcifs.rap.group.GroupUsersInfo;
import jcifs.rap.user.UserManagement;
import jcifs.smb.NtlmPasswordAuthentication;

public class AuthenticatedRequest
extends HttpServletRequestWrapper {
    private final Principal principal;
    private final String authType;
    private Set groups;

    public AuthenticatedRequest(HttpServletRequest request, Principal principal, String authType) {
        super(request instanceof AuthenticatedRequest ? (HttpServletRequest)((AuthenticatedRequest)request).getRequest() : request);
        this.principal = principal;
        this.authType = authType;
    }

    public String getRemoteUser() {
        return this.principal.getName();
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean isUserInRole(String role) {
        if (super.isUserInRole(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        Set groups = this.getGroups();
        return groups != null ? groups.contains(role.toUpperCase()) : false;
    }

    private Set getGroups() {
        if (this.groups != null) {
            return this.groups;
        }
        try {
            UserManagement userManagement;
            String username;
            Principal principal = this.getUserPrincipal();
            if (principal instanceof NtlmPasswordAuthentication) {
                NtlmPasswordAuthentication auth = (NtlmPasswordAuthentication)principal;
                username = auth.getUsername();
                String target = auth.getDomain();
                if ("?".equals(target)) {
                    target = null;
                }
                if (auth.getPassword() == null) {
                    auth = null;
                }
                userManagement = new UserManagement(target, auth);
            } else {
                username = principal.getName();
                int index = username.indexOf(64);
                if (index != -1) {
                    username = username.substring(0, index);
                }
                userManagement = new UserManagement();
            }
            TreeSet<String> groups = new TreeSet<String>();
            GroupUsersInfo[] groupList = userManagement.netUserGetGroups(username, 0);
            if (groupList != null) {
                for (int i = groupList.length - 1; i >= 0; --i) {
                    groups.add(groupList[i].name.toUpperCase());
                }
            }
            this.groups = groups;
            return this.groups;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.groups = null;
            return null;
        }
    }
}

