# Getting Started for .NET

This repository contains sample applications written in C# and ASP.NET Core that run on Google Cloud.

See [the documentation](https://cloud.google.com/dotnet/getting-started/hello-world) for instructions on how to build, run, and deploy the samples.

## Samples

*   **[HelloWorld](./HelloWorld)**: A basic ASP.NET Core application that can be deployed to Cloud Run or Compute Engine.
*   **[Bookshelf](./Bookshelf)**: An end-to-end sample application showing how to use Cloud Firestore, Cloud Storage, and Cloud SQL.
*   **[BackgroundProcessing](./BackgroundProcessing)**: Demonstrates how to perform background tasks using Cloud Pub/Sub and the Cloud Translation API.
*   **[Sessions](./Sessions)**: Shows how to manage user sessions using Cloud Firestore.

## Cloud APIs used

The samples demonstrate how to use several Google Cloud APIs:

*   [Cloud Firestore](https://cloud.google.com/firestore/docs/)
*   [Cloud SQL](https://cloud.google.com/sql/docs/)
*   [Cloud Storage](https://cloud.google.com/storage/docs/)
*   [Cloud Pub/Sub](https://cloud.google.com/pubsub/docs/)
*   [Cloud Translation](https://cloud.google.com/translate/docs/)
*   [Cloud Key Management Service (KMS)](https://cloud.google.com/kms/docs/)

## Contributing changes

*   See [CONTRIBUTING.md](CONTRIBUTING.md)

## Licensing

*   See [LICENSE](LICENSE)
