rd_("dBlueeGreencRedCd<code>Arg</code> or <code>ArgGroup</code> identifierDjRepresents an I/O error. Can occur when writing to <code>stderr</code> \xe2\x80\xa6AjContains the success valueClSet the identifier used for referencing this argument in \xe2\x80\xa6AdSets the group name.CgCreate a <code>Style</code> with this as the foreground000CkThe abstract representation of a command line argument. \xe2\x80\xa60AhContains the error valueDkRed: #1 (foreground code <code>31</code>, background code <code>41</code>).Ak24-bit ANSI RGB color codesCfWhen encountered, store the associated value(s) in \xe2\x80\xa60AlA UTF-8-encoded fixed stringAeComplete web address.0CeExtend <code>Arg</code> with <code>ArgExt</code> dataCmExtend <code>Command</code> with <code>CommandExt</code> dataBfAdds an argument to this group by nameCdAdds an argument to the list of valid possibilities.BoCreate an <code>Arg</code> from a usage string.DiRead from <code>name</code> environment variable when argument is not \xe2\x80\xa6AmAccess an <code>ArgExt</code>BaAccess an <code>CommandExt</code>AiLookup a piece of contextBcExample: git-like CLI (Builder API)0FjIterate over <code>Arg</code> and <code>ArgGroup</code> <code>Id</code>s via <code>ArgMatches::ids</code>.CoAdapt a <code>TypedValueParser</code> from one value to anotherCaCreate a new <code>Arg</code> with a unique name.CcCreate a <code>ArgGroup</code> using a unique name.CbCreates a new instance of an <code>Command</code>.BaCustom parser for argument valuesCbCreate a <code>PossibleValue</code> with its name.nCreate a rangeAfCreate an empty bufferCcImplementation for <code>ValueParser::string</code>CfImplementation for <code>ValueParser::os_string</code>CeImplementation for <code>ValueParser::path_buf</code>AoParse an <code>ValueEnum</code>DkVerify the value is from an enumerated set of <code>PossibleValue</code>\xe2\x80\xa6BeSelect full range of <code>i64</code>BeSelect full range of <code>u64</code>CaImplementation for <code>ValueParser::bool</code>DdParse false-like string values, everything else is <code>true</code>AmParse bool-like string valuesAmParse non-empty string valuesAbNo effects enabled0BjCreate an error with a pre-defined messageB`Consume all following arguments.AkCreate an unformatted errorClEnable or disable the specified effects depending on the \xe2\x80\xa6BhAvailable 4-bit ANSI color palette codesCgParse a set of arguments into a user-defined container.CmEnables colored output only when the output is going to a \xe2\x80\xa6DlBlue: #4 (foreground code <code>34</code>, background code <code>44</code>).nA single valueDlCyan: #6 (foreground code <code>36</code>, background code <code>46</code>).CjWhen encountered, display <code>Command::print_help</code>0Dj<code>ContextKind</code> is self-sufficient, no additional information \xe2\x80\xa6AbDocumentation: FAQBfDisplay using ANSI Escape Code stylingBmAdds multiple arguments to this group by nameCkAdds multiple arguments to the list of valid possibilities.AnApply <code>bold</code> effectBl<code>bool</code> parser for argument valuesCf<strong>Command Line Argument Parser for Rust</strong>AkPrints the error and exits.BdExample: find-like CLI (Builder API)0AoReturns the argument unchanged.000000000000000000000000000000000000000000000000000DfSets the description of the argument for short help (<code>-h</code>).BgSets the help description of the value.BlDo not display the argument in help message.DjSpecifies that this <code>subcommand</code> should be hidden from help \xe2\x80\xa6CaHides this value from help and shell completions.BaCalls <code>U::from(self)</code>.000000000000000000000000000000000000000000000000000AlIterate over enabled effectsBiType of error for programmatic processingCmThis arg is the last, or final, positional argument (i.e. \xe2\x80\xa6CeSets the long version of the argument without the \xe2\x80\xa6An(Re)Sets the program\xe2\x80\x99s name.BcExample: Command REPL (Builder API)0DmBlack: #0 (foreground code <code>30</code>, background code <code>40</code>).AjAny ANSI color code schemeEcWhen encountered, increment a <code>u8</code> counter starting from <code>0</code>.0AnNor argument values, or a flagBbCommand Line Argument Parser Error0DmGreen: #2 (foreground code <code>32</code>, background code <code>42</code>).ClDisables colored output no matter if the output is going \xe2\x80\xa6AlA UTF-8-encoded fixed stringClNone of the hints below apply. Disables shell completion \xe2\x80\xa60AcReset builder valueAiReset terminal formattingAaANSI Text stylingnA usage stringAgOverwrite builder valueAgArgument\xe2\x80\x99s value typeDmWhite: #7 (foreground code <code>37</code>, background code <code>47</code>).DfSets the program\xe2\x80\x99s description for the short help (<code>-h</code>).CdAdd an alias, which functions as a hidden long flag.BgSets a hidden alias to this subcommand.CeSets a <em>hidden</em> alias for this argument value.BkApply an alternative formatter to the errorAoApply <code>blink</code> effectCoPrepare for introspecting on all included <code>Command</code>sAjReset all effects in-placeAjSets when to color output.CjDelay initialization for parts of the <code>Command</code>oError reportingC`Custom error message for post-parsing validationmError headingCnThe name of the <code>ArgGroup</code> the argument belongs to.CaAdds an <code>ArgGroup</code> to the application.DlSpecifies the index of a positional argument <strong>starting at</strong> 1.AaGet the raw valueCkParse from <code>std::env::args_os()</code>, exit on error.AhParse the argument valueAcNo terminal stylingEdPrints formatted and colored error to <code>stdout</code> or <code>stderr</code> \xe2\x80\xa6AjNarrow the supported range0CfSets the short version of the argument without the \xe2\x80\xa6mUsage headingAiHighlight suggested usageCkEnables colored output regardless of whether or not the \xe2\x80\xa6CfWhen encountered, store the associated value(s) in \xe2\x80\xa60CnUser-provided data that can be attached to an <code>Arg</code>AmAn opaque message to the userBlDoes the argument match the specified value?DhRepresents a Format error (which is a part of <code>Display</code>). \xe2\x80\xa6CgSwap foreground and background colors; inconsistent \xe2\x80\xa6CkNot widely supported. Sometimes treated as inverse or blinkFjIterate over <code>Arg</code> and <code>ArgGroup</code> <code>Id</code>s via <code>ArgMatches::ids</code>.nA single valueCcGenerated parser, usually <code>ValueParser</code>.CdParse command-line arguments into <code>Self</code>.BgShort hand for <code>Result</code> typeCiA single argument value, the most common case for options4AlTerminal styling definitions0CdIterate over multiple values for an argument via \xe2\x80\xa6DnYellow: #3 (foreground code <code>33</code>, background code <code>43</code>).CdSpecify how to react to an argument when parsing it.C`Type for value stored in <code>ArgMatches</code>BiGet the raw string of the <code>Id</code>BjGet the raw string of the <code>Str</code>CfEnd-user description of the error case, where relevant0BhSets the author(s) for the help message.AoChange the color to/from brightB`Apply <code>dimmed</code> effectChFormat the existing message with the Command\xe2\x80\x99s contextAlGet the name of the argumentAiGet the name of the groupCjSpecifies that an argument can be matched to all child \xe2\x80\xa6CoThe names of <code>ArgGroup</code>\xe2\x80\x99s the argument belongs to.DiAdds multiple <code>ArgGroup</code>s to the <code>Command</code> at once.CeGeneral Heading style, e.g. <code>help_heading</code>B`Apply <code>hidden</code> effectBgInserts the specified effects in-place.AiInsert a piece of contextB`Apply <code>invert</code> effectB`Apply <code>italic</code> effectBfExample: pacman-like CLI (Builder API)0AhParse the argument valueBi<code>Command</code> line argument parserAmRemove an <code>ArgExt</code>BaRemove an <code>CommandExt</code>BgRemoves the specified effects in-place.CfRemove a piece of context, return the old value if anyAdRender the ANSI code00CeRender the error message to a <code>StyledStr</code>.Bn<code>String</code> parser for argument valuesAhDefault terminal stylingC`Sets the <code>Styles</code> for terminal outputAi256 (8-bit) color supportAbAny existing path.0AoBuild a command-line interface.0AdPath to a directory.0AeA set of text effectsClIterate over indices for where an argument appeared when \xe2\x80\xa6DoMagenta: #5 (foreground code <code>35</code>, background code <code>45</code>).EdWhen encountered, act as if <code>&quot;true&quot;</code> was encountered on the \xe2\x80\xa60kMany valuesCiDefault value if hint is not specified. Follows shell \xe2\x80\xa60CgWhen encountered, display <code>Command::version</code>0AoDocumentation: Derive ReferenceCaAdd aliases, which function as hidden long flags.C`Sets multiple hidden aliases to this subcommand.CnSets multiple <em>hidden</em> aliases for this argument value.BjDefine <code>Command</code> line argumentsDdBuild a <code>Command</code> that can instantiate <code>Self</code>.DcAllows you to build the <code>Command</code> instance from your \xe2\x80\xa6DdHighlight all specified contexts, e.g. <code>[default: false]</code>CcAdditional information to further qualify the errorA`Set text effectsChGet the environment variable name specified for this \xe2\x80\xa6CkGets the value of a specific option or positional argument.BjIterate over the original argument values.AgHighlight invalid usageCeLiteral command-line syntax, e.g. <code>--help</code>CcTests if the value is valid for this argument valueDiAllows one to mutate an <code>Arg</code> after it\xe2\x80\x99s been added to a \xe2\x80\xa6CfTerminal <code>Styles</code> for help and error outputAlProvide a general suggestionCoAdapt a <code>TypedValueParser</code> from one value to anotherBnDescribes the content of <code>AnyValue</code>DeSets the version for the short version (<code>-V</code>) and help \xe2\x80\xa6BfSpecifies a logical group of arguments0CnFailed to downcast <code>AnyValue</code> to the specified typeoPath to a file.0CoWhen encountered, display <code>Command::print_long_help</code>0DiHost name of a computer. Shells usually parse <code>/etc/hosts</code> \xe2\x80\xa60CkOccurs when the user doesn\xe2\x80\x99t use equals for an option \xe2\x80\xa6AbExisting argumentsAk24-bit ANSI RGB color codesEeWhen encountered, act as if <code>&quot;false&quot;</code> was encountered on the \xe2\x80\xa60BfName of a local operating system user.0AdSet background colorCkOverrides the runtime-determined name of the binary for \xe2\x80\xa6EgReturns <code>true</code> if all of the effects in <code>other</code> are contained \xe2\x80\xa6AnThe target type to downcast toAdSet foreground colorBiParse an argument into <code>Self</code>.D`Getters for all args. It will return a vector of <code>Id</code>DcGets the value of a specific <code>ArgAction::SetTrue</code> or \xe2\x80\xa6C`Get the help specified for this argument, if any0CbGet the long option name for this argument, if anyCjIterate over values of a specific option or positional \xe2\x80\xa6AhGet the name of the cmd.BbGet the name of the argument valueBeIterate through the <em>options</em>.CnReport the <code>ArgGroup::id</code> for this set of argumentsCeDo not display in help the environment variable name.BnThe first index of that an argument showed up.AoCheck if no effects are enabledAnCheck if no styling is enabledDkAllows more than one of the <code>Arg</code>s in this group to be used. \xe2\x80\xa6DiAllows one to mutate all <code>Arg</code>s after they\xe2\x80\x99ve been added \xe2\x80\xa6CgSpecifies the number of arguments parsed per occurrenceBo<code>PathBuf</code> parser for argument valuesDkAppends a given string slice onto the end of this <code>StyledStr</code>\xe2\x80\xa6BlSpecifies that the argument must be present.CiRequire an argument from the group to be present when \xe2\x80\xa6CjSets an argument that is required when this one is presentCjSpecify an argument or group that must be present when \xe2\x80\xa6CfApply <code>Command</code>\xe2\x80\x99s formatting to the errorAcWrite the ANSI codeBhAvailable 4-bit ANSI color palette codesCiBehavior of arguments when they are encountered while \xe2\x80\xa60EcBright red: #1 (foreground code <code>91</code>, background code <code>101</code>).BjCommand line argument parser kind of errorCjWhen encountered, display <code>Command::print_help</code>0AhIs the argument present?B`Minimum number of allowed valuesDfIterate over raw argument values via <code>ArgMatches::get_raw</code>.nA single valueAjTerminal-styling containerAjPotential fix for the userCiStyle extensions exist for Kitty, VTE, mintty and iTerm2.AkParse arguments into enums.CgProvide shell with hint on how to complete an argument.0CdIterate over multiple values for an argument via \xe2\x80\xa6lCLI ConceptsAgDocumentation: Cookbook0AlDocumentation: Feature FlagsAlTutorial for the Builder APIAkTutorial for the Derive APICeGet the raw string as an <code>std::ffi::OsStr</code>CmThis argument must be passed alone; it conflicts with all \xe2\x80\xa6DgReturns the exit code that <code>.exit</code> will exit the process \xe2\x80\xa6BnLosslessly convert from <code>AnsiColor</code>CoGet the help message specified via <code>Command::about</code>.AkShould we color the output?CoGets the value of a specific <code>ArgAction::Count</code> flagmError headingBfGet the index of this argument, if anyCcGet the short option name for this argument, if anymUsage headingAiHighlight suggested usageCmConvert to <code>AnsiColor</code> when there is a 1:1 mappingBbReport whether the color is brightClSets the long version of the subcommand flag without the \xe2\x80\xa6DjSets the description of the argument for long help (<code>--help</code>\xe2\x80\xa6CnMultiple-personality program dispatched on the binary name \xe2\x80\xa6DiAllows one to mutate an <code>ArgGroup</code> after it\xe2\x80\x99s been added \xe2\x80\xa6C`<code>OsString</code> parser for argument valuesAhParse the argument valueBkRender the ANSI code for a background color000BkRender the ANSI code for a foreground color000DaParse from <code>std::env::args_os()</code>, return Err on error.BcApply <code>underline</code> effectAlContainer for parse results.0EdBright blue: #4 (foreground code <code>94</code>, background code <code>104</code>).EdBright cyan: #6 (foreground code <code>96</code>, background code <code>106</code>).CnUser-provided data that can be attached to an <code>Arg</code>CdEnumerate each enabled value in <code>Effects</code>AfThe cause of the errorAgClearable builder valuejmany valueBmParse a sub-command into a user-defined enum.oAccepted valuesBeValues per occurrence for an argumentDkFree-form help text for after auto-generated short help (<code>-h</code>\xe2\x80\xa6CgAllows you to pull the name from your Cargo.toml at \xe2\x80\xa6BbBehavior when parsing the argumentAkGet the authors of the cmd.BbIterate through the set of groups.CeGeneral Heading style, e.g. <code>help_heading</code>DcReturn the current <code>Styles</code> for the <code>Command</code>BbExample: git-like CLI (Derive API)0CaAll indices an argument appeared at when parsing.DjSets the program\xe2\x80\x99s description for the long help (<code>--help</code>\xe2\x80\xa6BjMost number of values the argument acceptsBlFewest number of values the argument acceptsCgCreate a <code>Style</code> with this as the foreground000BcParse from iterator, exit on error.AhParse the argument valueDmPrints the short help message (<code>-h</code>) to <code>io::stdout()</code>.ChReturns the value of a specific option or positional \xe2\x80\xa6CmSets the short version of the subcommand flag without the \xe2\x80\xa6CeAdds a subcommand to the list of valid possibilities.CoThe name and <code>ArgMatches</code> of the current subcommand.CgSets the terminal width at which to wrap help messages.ClShould the message be written to <code>stdout</code> or not?CgProvide the shell a hint about how to complete this \xe2\x80\xa6CnPlaceholder for the argument\xe2\x80\x99s value in the help message \xe2\x80\xa6EeBright black: #0 (foreground code <code>90</code>, background code <code>100</code>).EeBright green: #2 (foreground code <code>92</code>, background code <code>102</code>).EeBright white: #7 (foreground code <code>97</code>, background code <code>107</code>).CcRepresents the color preferences for program outputBgValue was passed in on the command-lineClName of a command, without arguments. May be relative to \xe2\x80\xa60BjSemantics for a piece of error informationDiNot a true \xe2\x80\x9cerror\xe2\x80\x9d as it means <code>--help</code> or similar was \xe2\x80\xa6B`Value came <code>Arg::env</code>ClOccurs when the user provides a value containing invalid \xe2\x80\xa6AaTrailing argumentAnParse/validate argument valuesB`Origin of the argument\xe2\x80\x99s valueAfExtend the suggestionsCmFree-form help text for before auto-generated short help (\xe2\x80\xa6ChCheck if values are present for the argument or group idBlGet hidden aliases for this argument, if anyD`Iterate through the <em>hidden</em> aliases for this subcommand.DdHighlight all specified contexts, e.g. <code>[default: false]</code>AgHighlight invalid usageCeLiteral command-line syntax, e.g. <code>--help</code>CdParse <code>env::args_os</code>, exiting on failure.AkGet the version of the cmd.DkMatch values against <code>PossibleValuesParser</code> without matching \xe2\x80\xa6BlReport whether <code>Arg::hide</code> is setC`Report whether <code>Command::hide</code> is setCaReport if <code>PossibleValue::hide</code> is setBmReports whether <code>Arg::last</code> is setChReturn true if the group allows more than one of the \xe2\x80\xa6DeDescriptions within command-line syntax, e.g. <code>value_name</code>CjReturn values of a specific option or positional argument.DkRender the short help message (<code>-h</code>) to a <code>StyledStr</code>AjExample: REPL (Derive API)0CdRequire another argument if this arg matches the \xe2\x80\xa6CeAdd an alias, which functions as a hidden short flag.CbAdds multiple subcommands to the list of valid \xe2\x80\xa6AoSuggest an alternative argumentCiNon-panicking version of <code>ArgMatches::get_one</code>CiNon-panicking version of <code>ArgMatches::get_raw</code>BdUpdate from iterator, exit on error.ChPlaceholders for the argument\xe2\x80\x99s values in the help \xe2\x80\xa6Ai256 (8-bit) color supportBhOperations to perform on argument valuesEgBright yellow: #3 (foreground code <code>93</code>, background code <code>103</code>\xe2\x80\xa6AlA piece of error informationBjValue came <code>Arg::default_value</code>nEmail address.0oRejected valuesDiOccurs when an <code>Arg</code> has a set of possible values, and the \xe2\x80\xa6C`Violation of <code>ArgMatches</code> assumptionsAjPotential fix for the userCnOccurs when the user provides fewer values for an argument \xe2\x80\xa6CoCheck if any <code>Arg</code>s were present on the command lineDnAppend to <code>Command</code> so it can instantiate <code>Self</code> via \xe2\x80\xa6C`Catch problems earlier in the development cycle.ChOverrides the runtime-determined display name of the \xe2\x80\xa6CiFlatten subcommand help into the current command\xe2\x80\x99s helpBbStylize the error for the terminalAhGet the background colorAkGet the name of the binary.AhGet the foreground colorBkGet the number of values for this argument.CiOverride the <code>--help</code> section this appears in.DkSets the version for the long version (<code>--version</code>) and help \xe2\x80\xa6BlRenders the relevant <code>Reset</code> codeoUsage statementCnSpecify arguments or groups that must be present when this \xe2\x80\xa6BiAllows multiple conditional requirements.DnSet binary name. Uses <code>&amp;mut self</code> instead of <code>self</code>.CeReturns whether this action accepts values on the \xe2\x80\xa6CkReport whether the argument takes any values (ie is a flag)BnGet the raw string as an <code>OsString</code>BoClears the values for the given <code>id</code>CjNon-panicking version of <code>ArgMatches::get_many</code>BbExample: Custom Types (Derive API)0BkSpecify the typed behavior of the argument.DgSelect a <code>ValueParser</code> implementation from the intended typeBnCreate the specified <code>Self::Parser</code>BeReport where argument value came fromEhBright magenta: #5 (foreground code <code>95</code>, background code <code>105</code>\xe2\x80\xa6CgA single string containing a command and its arguments.0AmReport <code>ErrorKind</code>B`A possible value of an argument.AnRichly formatted error contextCiCharacters legible but marked as if for deletion. Not \xe2\x80\xa6CkOccurs when a user provides more values for an argument \xe2\x80\xa6BgExample: cargo subcommand (Builder API)0DkHighlight values within all of the context, e.g. the <code>false</code> \xe2\x80\xa6ClAllows you to pull the authors for the command from your \xe2\x80\xa6CjAllows you to pull the version from your Cargo.toml at \xe2\x80\xa6BhValue for the argument when not present.CgAllows custom ordering of args within the help message.CeSet the placement of this subcommand within the help.BeIterate through the set of arguments.BdGet the long flag of the subcommand.CeGet the long help specified for this argument, if anyBgPanic if help descriptions are omitted.CmSets the help template to be used, overriding the default \xe2\x80\xa6ChTry not to fail on parse errors, like missing option \xe2\x80\xa6BnReport whether <code>Arg::global</code> is setCdChecks whether this argument is a positional or not.EdOverrides the <code>clap</code> generated help message (both <code>-h</code> and \xe2\x80\xa6CdAdd aliases, which functions as a hidden short flag.BgApply <code>strikethrough</code> effectCeAdd an alias, which functions as a visible long flag.BhSets a visible alias to this subcommand.DdCreate a <code>Command</code> relevant for a user-defined container.DhNot a true \xe2\x80\x9cerror\xe2\x80\x9d as it means <code>--version</code> or similar \xe2\x80\xa6CiDefines how to format an error for displaying to the userAkPath to an executable file.0DeConverts an instance of <code>ArgMatches</code> to a user-defined \xe2\x80\xa6BgConvert to the intended resettable typeCoAdapt a <code>TypedValueParser</code> from one value to anotherAjPotential fix for the userCjThis argument is mutually exclusive with the specified \xe2\x80\xa6DoSpecify an argument or group that must <strong>not</strong> be present when \xe2\x80\xa6BhValue for the argument when not present.CaReturns the help heading for listing subcommands.DdGet the help message specified via <code>Command::long_about</code>.BeGet the short flag of the subcommand.BcGet the value hint of this argumentCnTest whether <code>Self</code> can parse a specific subcommandCgHides an argument from long help (<code>--help</code>).CjLimit the line length for wrapping help when using the \xe2\x80\xa6DjAllows one to mutate a <code>Command</code> after it\xe2\x80\x99s been added as \xe2\x80\xa6BoRender the help on the line after the argument.ClPlaces the help string for all arguments and subcommands \xe2\x80\xa6CiSpecifies that the parser should not assume the first \xe2\x80\xa6DgOverrides the <code>clap</code> generated usage string for help and \xe2\x80\xa6AmSets an overridable argument.ClVersion message rendered as if the user ran <code>-V</code>.CnRequires that options use the <code>--option=val</code> syntaxDgThis argument is required only if the specified <code>arg</code> is \xe2\x80\xa6BiParse from iterator, return Err on error.ClNon-panicking version of <code>ArgMatches::remove_one</code>BoAll possible argument values, in display order.BjWrite the relevant <code>Reset</code> codeAhNumber of values presentCaImplementation for <code>ValueParser::bool</code>BfParse an <code>ValueEnum</code> value.CkOccurs when a user provides a flag, option, argument or \xe2\x80\xa6BlArgument not defined in <code>Command</code>AdAccepted subcommandsCnOccurs when the user provides a value for an argument with \xe2\x80\xa6CkFree-form help text for after auto-generated long help (\xe2\x80\xa6ChFind subcommand such that its name or one of aliases \xe2\x80\xa6DdGet <em>all</em> aliases for this argument, if any, both visible \xe2\x80\xa6D`Iterate through the set of <em>all</em> the aliases for this \xe2\x80\xa6CaReturns the help heading for listing subcommands.CdParse <code>env::args_os</code>, exiting on failure.CkIterate over the values passed to each occurrence of an \xe2\x80\xa6DeDescriptions within command-line syntax, e.g. <code>value_name</code>CcIterate through the <em>positionals</em> arguments.CeIterate through the set of subcommands, getting a \xe2\x80\xa6BjGet the names of values for this argument.DgReturns <code>true</code> if this <code>Command</code> has subcommands.CkDo not display in help any values inside the associated \xe2\x80\xa6CdHides an argument from short help (<code>-h</code>).CiAllow partial matches of long arguments or their aliases.BgConvert to the intended resettable typeC`Report whether <code>Arg::hide_env</code> is setCaReports whether <code>Arg::required</code> is setCfReports whether <code>ArgGroup::required</code> is setCmAdd an alias, which functions as a \xe2\x80\x9chidden\xe2\x80\x9d long flag \xe2\x80\xa6DgAllows one to mutate all <code>Command</code>s after they\xe2\x80\x99ve been \xe2\x80\xa6BgReport all <code>possible_values</code>BfReflect on enumerated value properties0E`Prints the long help message (<code>--help</code>) to <code>io::stdout()</code>.BcThe name of the current subcommand.CmNon-panicking version of <code>ArgMatches::contains_id</code>EbParse <code>env::args_os</code>, returning a <code>clap::Result</code> on failure.CmNon-panicking version of <code>ArgMatches::remove_many</code>BjUpdate from iterator, return Err on error.AcSet underline colorCbAllow grouping of multiple values via a delimiter.CbAdd aliases, which function as visible long flags.CaSets multiple visible aliases to this subcommand.CkOccurs when the user provides two values which conflict \xe2\x80\xa6AnRichly formatted error contextAjPotential fix for the userAnParse/validate argument valuesClFree-form help text for before auto-generated long help (\xe2\x80\xa6DiSpecifies the value of the argument if <code>arg</code> has been used \xe2\x80\xa6EhInstantiate <code>Self</code> from <code>ArgMatches</code>, parsing the arguments as \xe2\x80\xa6AkGet the name of the binary.ChGet the help heading specified for this argument, if anyB`Get the long version of the cmd.CbParse the specified arguments, exiting on failure.BeConfigured parser for argument valuesCbReports whether <code>Arg::exclusive</code> is setCeReport whether <code>Command::multicall</code> is setDoRender the long help message (<code>--help</code>) to a <code>StyledStr</code>.CmAdd an alias, which functions as  \xe2\x80\x9chidden\xe2\x80\x9d short flag \xe2\x80\xa6CnThis is a \xe2\x80\x9cvar arg\xe2\x80\x9d and everything that follows should \xe2\x80\xa6DhSentinel to <strong>stop</strong> parsing multiple values of a given \xe2\x80\xa6AhNumber of allowed valuesDdParse false-like string values, everything else is <code>true</code>AfThe cause of the errorDiOccurs when the user provides an unrecognized <code>Subcommand</code> \xe2\x80\xa6CgOccurs when a subcommand is required (as defined by \xe2\x80\xa6CcImplementation for <code>ValueParser::string</code>CoAdapt a <code>TypedValueParser</code> from one value to anotherCnAllows you to pull the description from your Cargo.toml at \xe2\x80\xa6ChSpecifies multiple values and conditions in the same \xe2\x80\xa6DjSpecifies the values of the argument if <code>arg</code> has been used \xe2\x80\xa6CfDisables <code>-h</code> and <code>--help</code> flag.DkHighlight values within all of the context, e.g. the <code>false</code> \xe2\x80\xa6AmGet the placement within help0CnAllow partial matches of subcommand names and their aliases\xe2\x80\xa6CiAdd aliases, which function as \xe2\x80\x9chidden\xe2\x80\x9d long flag \xe2\x80\xa6BgExample: busybox-like CLI (Builder API)0C`Set the default section heading for future args.CkSpecifies to use the version of the current command for \xe2\x80\xa6DfReturn the name and <code>ArgMatches</code> of the current subcommand.AmThe canonical argument value.AmParse bool-like string valuesCeImplementation for <code>ValueParser::path_buf</code>BoRegister a type with <code>value_parser!</code>ChReplace prior occurrences of arguments rather than errorCoBuild a <code>Command</code> that can update <code>self</code>.CjThis argument is mutually exclusive with the specified \xe2\x80\xa6DnSpecify arguments or groups that must <strong>not</strong> be present when \xe2\x80\xa6ChSpecifies multiple values and conditions in the same \xe2\x80\xa6AeExample (Builder API)0CjGet the default values specified for this argument, if anyCkDo not display the default value of the argument in the \xe2\x80\xa6CdReports whether <code>Arg::ignore_case</code> is setBhExample: hostname-like CLI (Builder API)0CjChange the starting value for assigning future display \xe2\x80\xa6CeSets multiple mutually overridable arguments by name.BoReturn values for each occurrence of an option.CgSpecify this argument is required based on multiple \xe2\x80\xa60CjAdd aliases, which function as \xe2\x80\x9chidden\xe2\x80\x9d short flag \xe2\x80\xa6CgThe <code>ArgMatches</code> for the current subcommand.CfImplementation for <code>ValueParser::os_string</code>AjPotential fix for the userCnOccurs when the user provides a different number of values \xe2\x80\xa6D`Allows values which start with a leading hyphen (<code>-</code>)DnAppend to <code>Command</code> so it can instantiate <code>Self</code> via \xe2\x80\xa6ChFind subcommand such that its name or one of aliases \xe2\x80\xa6CaReturns the help heading for listing subcommands.ClGet the names of possible values for this argument. Only \xe2\x80\xa6CnIterate over the original values for each occurrence of an \xe2\x80\xa6CmIterate through the set of subcommands, getting a mutable \xe2\x80\xa6BiGet the delimiter between multiple valuesBmGet visible aliases for this argument, if anyDaIterate through the <em>visible</em> aliases for this subcommand.C`Get the custom section heading specified via \xe2\x80\xa6DcVersion message rendered as if the user ran <code>--version</code>.DgIf no <code>subcommand</code> is present at runtime, error and exit \xe2\x80\xa6DaNon-panicking version of <code>ArgMatches::get_occurrences</code>CfAdd an alias, which functions as a visible short flag.CiCapture the remaining arguments as a command name and \xe2\x80\xa60DkVerify the value is from an enumerated set of <code>PossibleValue</code>\xe2\x80\xa6BoParse number that fall within a range of values0BfExample: cargo subcommand (Derive API)0BaDisables colorized help messages.CiDisables <code>-V</code> and <code>--version</code> flag.EhInstantiate <code>Self</code> from <code>ArgMatches</code>, parsing the arguments as \xe2\x80\xa6CaReturns the help heading for listing subcommands.BoReturns all valid values of the argument value.CcGet the value terminator for this argument. The \xe2\x80\xa6CgDo not display the possible values in the help message.EaTells <code>clap</code> <em>not</em> to print possible values when displaying \xe2\x80\xa6DkParse the specified arguments, returning a <code>clap::Result</code> on \xe2\x80\xa6CjValue for the argument when the flag is present but no \xe2\x80\xa6DbGet <em>all</em> short aliases for this argument, if any, both \xe2\x80\xa6C`Get the custom section heading specified via \xe2\x80\xa6CfReport whether <code>Arg::hide_long_help</code> is setCfReport whether <code>Arg::next_line_help</code> is setCjReport whether <code>Command::next_line_help</code> is setCjReport whether <code>Command::no_binary_name</code> is setCfReport whether <code>Arg::require_equals</code> is setCjSets the value name used for subcommands when printing \xe2\x80\xa6CcAdd aliases, which function as visible short flags.BjAllows negative numbers to pass as values.DjExit gracefully if no arguments are present (e.g. <code>$ myprog</code>\xe2\x80\xa6;ClGet a list of all arguments the given argument conflicts \xe2\x80\xa6CgReport whether <code>Arg::hide_env_values</code> is setCgReport whether <code>Arg::hide_short_help</code> is setDdNon-panicking version of <code>ArgMatches::remove_occurrences</code>CnOccurs when the user does not provide one or more required \xe2\x80\xa6DnAppend to <code>Command</code> so it can instantiate <code>self</code> via \xe2\x80\xa6CgDisables the <code>help</code> <code>subcommand</code>.ChReport whether <code>Arg::trailing_var_arg</code> is setCnSet this arg as required as long as the specified argument \xe2\x80\xa6ClSets the help heading used for subcommands when printing \xe2\x80\xa6DgAllows <code>subcommands</code> to override all requirements of the \xe2\x80\xa6DeNon-panicking version of <code>ArgMatches::get_raw_occurrences</code>D`Assign values from <code>ArgMatches</code> to <code>self</code>.CnAdd an alias, which functions as a \xe2\x80\x9cvisible\xe2\x80\x9d long flag \xe2\x80\xa6CdAllows one to implement two styles of CLIs where \xe2\x80\xa6CjValue for the argument when the flag is present but no \xe2\x80\xa6CmReport whether <code>Command::disable_help_flag</code> is setCmReport whether <code>Command::propagate_version</code> is setDkParse the specified arguments, returning a <code>clap::Result</code> on \xe2\x80\xa6CnAdd an alias, which functions as  \xe2\x80\x9cvisible\xe2\x80\x9d short flag \xe2\x80\xa6AmParse non-empty string values5AdExample (Derive API)0DeIterate through the set of <em>all</em> the long aliases for this \xe2\x80\xa6BbReturns the subcommand value name.CcGet visible short aliases for this argument, if anyCjReport whether <code>Arg::hide_default_value</code> is setCmAdd aliases, which function as <em>visible</em> long flag \xe2\x80\xa6D`When encountered, report <code>ErrorKind::UnknownArgument</code>DeAssume unexpected positional arguments are a <code>subcommand</code>.DfIterate through the set of <em>all</em> the short aliases for this \xe2\x80\xa6CkReport whether <code>Arg::allow_hyphen_values</code> is setCoReport whether <code>Command::subcommand_required</code> is setCnAdd aliases, which function as <em>visible</em> short flag \xe2\x80\xa6CaReturns the help heading for listing subcommands.D`Report whether <code>Command::disable_colored_help</code> is setD`Report whether <code>Command::disable_version_flag</code> is setClReport whether <code>Arg::hide_possible_values</code> is setDbSets this arg as required unless <em>all</em> of the specified \xe2\x80\xa6DbSets this arg as required unless <em>any</em> of the specified \xe2\x80\xa6D`Assign values from <code>ArgMatches</code> to <code>self</code>.DhDisables the automatic delimiting of values after <code>--</code> or \xe2\x80\xa6ChGet the long option name and its visible aliases, if anyCiGet all known names of the cmd (i.e. primary name and \xe2\x80\xa6CiGet the short option name and its visible aliases, if anyCnIterate through the <em>visible</em> long aliases for this \xe2\x80\xa6CnReport whether <code>Arg::allow_negative_numbers</code> is setDbReport whether <code>Command::arg_required_else_help</code> is setDnAppend to <code>Command</code> so it can instantiate <code>self</code> via \xe2\x80\xa6CoIterate through the <em>visible</em> short aliases for this \xe2\x80\xa6DcReport whether <code>Command::disable_help_subcommand</code> is setDcReport whether <code>Command::subcommand_negates_reqs</code> is setCkPrevent subcommands from being consumed as an arguments \xe2\x80\xa6CiSpecifies that use of an argument prevents the use of \xe2\x80\xa6DdReport whether <code>Command::allow_missing_positional</code> is setCeSpecifies how to parse external subcommand arguments.DfReport whether <code>Command::allow_external_subcommands</code> is setDhReport whether <code>Command::dont_delimit_trailing_values</code> is setCfConfigured parser for values passed to an external \xe2\x80\xa6DjReport whether <code>Command::subcommand_precedence_over_arg</code> is \xe2\x80\xa6DkReport whether <code>Command::args_conflicts_with_subcommands</code> is \xe2\x80\xa6DbOccurs when either an argument or a <code>Subcommand</code> is \xe2\x80\xa6")