(function() {
    var type_impls = Object.fromEntries([["clap",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#830\">Source</a><a href=\"#impl-Debug-for-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#831\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Error.html\" title=\"struct core::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","clap::Error"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#843\">Source</a><a href=\"#impl-Display-for-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a> for <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#844\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Error.html\" title=\"struct core::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Display.html#tymethod.fmt\">Read more</a></div></details></div></details>","Display","clap::Error"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#79\">Source</a><a href=\"#impl-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.raw\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#88\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.raw\" class=\"fn\">raw</a>(kind: <a class=\"enum\" href=\"clap/error/enum.ErrorKind.html\" title=\"enum clap::error::ErrorKind\">ErrorKind</a>, message: impl <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class=\"docblock\"><p>Create an unformatted error</p>\n<p>This is for you need to pass the error up to\na place that has access to the <code>Command</code> at which point you can call <a href=\"clap/error/struct.Error.html#method.format\" title=\"method clap::error::Error::format\"><code>Error::format</code></a>.</p>\n<p>Prefer <a href=\"clap/struct.Command.html#method.error\" title=\"method clap::Command::error\"><code>Command::error</code></a> for generating errors.</p>\n</div><div class=\"docblock scraped-example-list\"><span></span><h5 id=\"scraped-examples\"><a href=\"#scraped-examples\">Examples found in repository</a><a class=\"scrape-help\" href=\"scrape-examples-help.html\">?</a></h5><div class=\"scraped-example\" data-locs=\"[[[4,7],&#34;src/interop_hand_subcommand/hand_subcommand.rs.html#27-30&#34;,&#34;lines 27-30&#34;],[[8,11],&#34;src/interop_hand_subcommand/hand_subcommand.rs.html#31-34&#34;,&#34;lines 31-34&#34;],[[19,22],&#34;src/interop_hand_subcommand/hand_subcommand.rs.html#42-45&#34;,&#34;lines 42-45&#34;]]\"><div class=\"scraped-example-title\">examples/derive_ref/hand_subcommand.rs (<a href=\"src/interop_hand_subcommand/hand_subcommand.rs.html#27-30\">lines 27-30</a>)</div><div class=\"example-wrap digits-2\"><pre class=\"rust\"><code><span data-nosnippet>23</span>    <span class=\"kw\">fn </span>from_arg_matches(matches: <span class=\"kw-2\">&amp;</span>ArgMatches) -&gt; <span class=\"prelude-ty\">Result</span>&lt;<span class=\"self\">Self</span>, Error&gt; {\n<span data-nosnippet>24</span>        <span class=\"kw\">match </span>matches.subcommand() {\n<span data-nosnippet>25</span>            <span class=\"prelude-val\">Some</span>((<span class=\"string\">\"add\"</span>, args)) =&gt; <span class=\"prelude-val\">Ok</span>(<span class=\"self\">Self</span>::Add(AddArgs::from_arg_matches(args)<span class=\"question-mark\">?</span>)),\n<span data-nosnippet>26</span>            <span class=\"prelude-val\">Some</span>((<span class=\"string\">\"remove\"</span>, args)) =&gt; <span class=\"prelude-val\">Ok</span>(<span class=\"self\">Self</span>::Remove(RemoveArgs::from_arg_matches(args)<span class=\"question-mark\">?</span>)),\n<span data-nosnippet>27</span>            <span class=\"prelude-val\">Some</span>((<span class=\"kw\">_</span>, <span class=\"kw\">_</span>)) =&gt; <span class=\"prelude-val\">Err</span>(<span class=\"highlight focus\">Error::raw</span>(\n<span data-nosnippet>28</span>                ErrorKind::InvalidSubcommand,\n<span data-nosnippet>29</span>                <span class=\"string\">\"Valid subcommands are `add` and `remove`\"</span>,\n<span data-nosnippet>30</span>            )),\n<span data-nosnippet>31</span>            <span class=\"prelude-val\">None </span>=&gt; <span class=\"prelude-val\">Err</span>(<span class=\"highlight\">Error::raw</span>(\n<span data-nosnippet>32</span>                ErrorKind::MissingSubcommand,\n<span data-nosnippet>33</span>                <span class=\"string\">\"Valid subcommands are `add` and `remove`\"</span>,\n<span data-nosnippet>34</span>            )),\n<span data-nosnippet>35</span>        }\n<span data-nosnippet>36</span>    }\n<span data-nosnippet>37</span>    <span class=\"kw\">fn </span>update_from_arg_matches(<span class=\"kw-2\">&amp;mut </span><span class=\"self\">self</span>, matches: <span class=\"kw-2\">&amp;</span>ArgMatches) -&gt; <span class=\"prelude-ty\">Result</span>&lt;(), Error&gt; {\n<span data-nosnippet>38</span>        <span class=\"kw\">match </span>matches.subcommand() {\n<span data-nosnippet>39</span>            <span class=\"prelude-val\">Some</span>((<span class=\"string\">\"add\"</span>, args)) =&gt; <span class=\"kw-2\">*</span><span class=\"self\">self </span>= <span class=\"self\">Self</span>::Add(AddArgs::from_arg_matches(args)<span class=\"question-mark\">?</span>),\n<span data-nosnippet>40</span>            <span class=\"prelude-val\">Some</span>((<span class=\"string\">\"remove\"</span>, args)) =&gt; <span class=\"kw-2\">*</span><span class=\"self\">self </span>= <span class=\"self\">Self</span>::Remove(RemoveArgs::from_arg_matches(args)<span class=\"question-mark\">?</span>),\n<span data-nosnippet>41</span>            <span class=\"prelude-val\">Some</span>((<span class=\"kw\">_</span>, <span class=\"kw\">_</span>)) =&gt; {\n<span data-nosnippet>42</span>                <span class=\"kw\">return </span><span class=\"prelude-val\">Err</span>(<span class=\"highlight\">Error::raw</span>(\n<span data-nosnippet>43</span>                    ErrorKind::InvalidSubcommand,\n<span data-nosnippet>44</span>                    <span class=\"string\">\"Valid subcommands are `add` and `remove`\"</span>,\n<span data-nosnippet>45</span>                ))\n<span data-nosnippet>46</span>            }\n<span data-nosnippet>47</span>            <span class=\"prelude-val\">None </span>=&gt; (),\n<span data-nosnippet>48</span>        };\n<span data-nosnippet>49</span>        <span class=\"prelude-val\">Ok</span>(())\n<span data-nosnippet>50</span>    }</code></pre></div></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.format\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#94\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.format\" class=\"fn\">format</a>(self, cmd: &amp;mut <a class=\"struct\" href=\"clap/struct.Command.html\" title=\"struct clap::Command\">Command</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class=\"docblock\"><p>Format the existing message with the Command’s context</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#128\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.new\" class=\"fn\">new</a>(kind: <a class=\"enum\" href=\"clap/error/enum.ErrorKind.html\" title=\"enum clap::error::ErrorKind\">ErrorKind</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class=\"docblock\"><p>Create an error with a pre-defined message</p>\n<p>See also</p>\n<ul>\n<li><a href=\"clap/error/struct.Error.html#method.insert\" title=\"method clap::error::Error::insert\"><code>Error::insert</code></a></li>\n<li><a href=\"clap/error/struct.Error.html#method.with_cmd\" title=\"method clap::error::Error::with_cmd\"><code>Error::with_cmd</code></a></li>\n</ul>\n<h5 id=\"example\"><a class=\"doc-anchor\" href=\"#example\">§</a>Example</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">let </span>cmd = clap::Command::new(<span class=\"string\">\"prog\"</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>err = clap::Error::new(ErrorKind::ValueValidation)\n    .with_cmd(<span class=\"kw-2\">&amp;</span>cmd);\nerr.insert(ContextKind::InvalidArg, ContextValue::String(<span class=\"string\">\"--foo\"</span>.to_owned()));\nerr.insert(ContextKind::InvalidValue, ContextValue::String(<span class=\"string\">\"bar\"</span>.to_owned()));\n\nerr.print();</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_cmd\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#149\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.with_cmd\" class=\"fn\">with_cmd</a>(self, cmd: &amp;<a class=\"struct\" href=\"clap/struct.Command.html\" title=\"struct clap::Command\">Command</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class=\"docblock\"><p>Apply <a href=\"clap/struct.Command.html\" title=\"struct clap::Command\"><code>Command</code></a>’s formatting to the error</p>\n<p>Generally, this is used with <a href=\"clap/error/struct.Error.html#method.new\" title=\"associated function clap::error::Error::new\"><code>Error::new</code></a></p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.apply\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#172\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.apply\" class=\"fn\">apply</a>&lt;EF&gt;(self) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;EF&gt;<div class=\"where\">where\n    EF: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h4></section></summary><div class=\"docblock\"><p>Apply an alternative formatter to the error</p>\n<h5 id=\"example-1\"><a class=\"doc-anchor\" href=\"#example-1\">§</a>Example</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>cmd = Command::new(<span class=\"string\">\"foo\"</span>)\n    .arg(Arg::new(<span class=\"string\">\"input\"</span>).required(<span class=\"bool-val\">true</span>));\n<span class=\"kw\">let </span>matches = cmd\n    .try_get_matches_from([<span class=\"string\">\"foo\"</span>, <span class=\"string\">\"input.txt\"</span>])\n    .map_err(|e| e.apply::&lt;KindFormatter&gt;())\n    .unwrap_or_else(|e| e.exit());</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.kind\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#180\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.kind\" class=\"fn\">kind</a>(&amp;self) -&gt; <a class=\"enum\" href=\"clap/error/enum.ErrorKind.html\" title=\"enum clap::error::ErrorKind\">ErrorKind</a></h4></section></summary><div class=\"docblock\"><p>Type of error for programmatic processing</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.context\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#186\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.context\" class=\"fn\">context</a>(&amp;self) -&gt; impl <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/iter/traits/iterator/trait.Iterator.html\" title=\"trait core::iter::traits::iterator::Iterator\">Iterator</a>&lt;Item = (<a class=\"enum\" href=\"clap/error/enum.ContextKind.html\" title=\"enum clap::error::ContextKind\">ContextKind</a>, &amp;<a class=\"enum\" href=\"clap/error/enum.ContextValue.html\" title=\"enum clap::error::ContextValue\">ContextValue</a>)&gt;</h4></section><span class=\"item-info\"><div class=\"stab portability\">Available on <strong>crate feature <code>error-context</code></strong> only.</div></span></summary><div class=\"docblock\"><p>Additional information to further qualify the error</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.get\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#193\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.get\" class=\"fn\">get</a>(&amp;self, kind: <a class=\"enum\" href=\"clap/error/enum.ContextKind.html\" title=\"enum clap::error::ContextKind\">ContextKind</a>) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;&amp;<a class=\"enum\" href=\"clap/error/enum.ContextValue.html\" title=\"enum clap::error::ContextValue\">ContextValue</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab portability\">Available on <strong>crate feature <code>error-context</code></strong> only.</div></span></summary><div class=\"docblock\"><p>Lookup a piece of context</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.insert\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#202\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.insert\" class=\"fn\">insert</a>(\n    &amp;mut self,\n    kind: <a class=\"enum\" href=\"clap/error/enum.ContextKind.html\" title=\"enum clap::error::ContextKind\">ContextKind</a>,\n    value: <a class=\"enum\" href=\"clap/error/enum.ContextValue.html\" title=\"enum clap::error::ContextValue\">ContextValue</a>,\n) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"clap/error/enum.ContextValue.html\" title=\"enum clap::error::ContextValue\">ContextValue</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab portability\">Available on <strong>crate feature <code>error-context</code></strong> only.</div></span></summary><div class=\"docblock\"><p>Insert a piece of context</p>\n<p>If this <code>ContextKind</code> is already present, its value is replaced and the old value is returned.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.remove\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#212\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.remove\" class=\"fn\">remove</a>(&amp;mut self, kind: <a class=\"enum\" href=\"clap/error/enum.ContextKind.html\" title=\"enum clap::error::ContextKind\">ContextKind</a>) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"clap/error/enum.ContextValue.html\" title=\"enum clap::error::ContextValue\">ContextValue</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab portability\">Available on <strong>crate feature <code>error-context</code></strong> only.</div></span></summary><div class=\"docblock\"><p>Remove a piece of context, return the old value if any</p>\n<p>The context is currently implemented in a vector, so <code>remove</code> takes\nlinear time.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.use_stderr\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#218\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.use_stderr\" class=\"fn\">use_stderr</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Should the message be written to <code>stdout</code> or not?</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.exit_code\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#233\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.exit_code\" class=\"fn\">exit_code</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.i32.html\">i32</a></h4></section></summary><div class=\"docblock\"><p>Returns the exit code that <code>.exit</code> will exit the process with.</p>\n<p>When the error’s kind would print to <code>stderr</code> this returns <code>2</code>,\nelse it returns <code>0</code>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.exit\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#245\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.exit\" class=\"fn\">exit</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.never.html\">!</a></h4></section></summary><div class=\"docblock\"><p>Prints the error and exits.</p>\n<p>Depending on the error kind, this either prints to <code>stderr</code> and exits with a status of <code>2</code>\nor prints to <code>stdout</code> and exits with a status of <code>0</code>.</p>\n</div><div class=\"docblock scraped-example-list\"><span></span><h5 id=\"scraped-examples-1\"><a href=\"#scraped-examples-1\">Examples found in repository</a><a class=\"scrape-help\" href=\"scrape-examples-help.html\">?</a></h5><div class=\"scraped-example expanded\" data-locs=\"[[[7,7],&#34;src/interop_augment_subcommands/augment_subcommands.rs.html#18&#34;,&#34;line 18&#34;]]\"><div class=\"scraped-example-title\">examples/derive_ref/augment_subcommands.rs (<a href=\"src/interop_augment_subcommands/augment_subcommands.rs.html#18\">line 18</a>)</div><div class=\"example-wrap digits-2\"><pre class=\"rust\"><code><span data-nosnippet>11</span><span class=\"kw\">fn </span>main() {\n<span data-nosnippet>12</span>    <span class=\"kw\">let </span>cli = Command::new(<span class=\"string\">\"Built CLI\"</span>);\n<span data-nosnippet>13</span>    <span class=\"comment\">// Augment with derived subcommands\n<span data-nosnippet>14</span>    </span><span class=\"kw\">let </span>cli = Subcommands::augment_subcommands(cli);\n<span data-nosnippet>15</span>\n<span data-nosnippet>16</span>    <span class=\"kw\">let </span>matches = cli.get_matches();\n<span data-nosnippet>17</span>    <span class=\"kw\">let </span>derived_subcommands = Subcommands::from_arg_matches(<span class=\"kw-2\">&amp;</span>matches)\n<span data-nosnippet>18</span>        .map_err(|err| err.<span class=\"highlight focus\">exit</span>())\n<span data-nosnippet>19</span>        .unwrap();\n<span data-nosnippet>20</span>    <span class=\"macro\">println!</span>(<span class=\"string\">\"Derived subcommands: {derived_subcommands:#?}\"</span>);\n<span data-nosnippet>21</span>}</code></pre></div></div><details class=\"toggle more-examples-toggle\"><summary class=\"hideme\"><span>More examples</span></summary><div class=\"hide-more\">Hide additional examples</div><div class=\"more-scraped-examples\"><div class=\"toggle-line\"><div class=\"toggle-line-inner\"></div></div><div class=\"scraped-example\" data-locs=\"[[[15,15],&#34;src/interop_augment_args/augment_args.rs.html#24&#34;,&#34;line 24&#34;]]\"><div class=\"scraped-example-title\">examples/derive_ref/augment_args.rs (<a href=\"src/interop_augment_args/augment_args.rs.html#24\">line 24</a>)</div><div class=\"example-wrap digits-2\"><pre class=\"rust\"><code><span data-nosnippet>9</span><span class=\"kw\">fn </span>main() {\n<span data-nosnippet>10</span>    <span class=\"kw\">let </span>cli = Command::new(<span class=\"string\">\"CLI\"</span>).arg(<span class=\"macro\">arg!</span>(-b - -built).action(clap::ArgAction::SetTrue));\n<span data-nosnippet>11</span>    <span class=\"comment\">// Augment built args with derived args\n<span data-nosnippet>12</span>    </span><span class=\"kw\">let </span>cli = DerivedArgs::augment_args(cli);\n<span data-nosnippet>13</span>\n<span data-nosnippet>14</span>    <span class=\"kw\">let </span>matches = cli.get_matches();\n<span data-nosnippet>15</span>    <span class=\"macro\">println!</span>(<span class=\"string\">\"Value of built: {:?}\"</span>, matches.get_flag(<span class=\"string\">\"built\"</span>));\n<span data-nosnippet>16</span>    <span class=\"macro\">println!</span>(\n<span data-nosnippet>17</span>        <span class=\"string\">\"Value of derived via ArgMatches: {:?}\"</span>,\n<span data-nosnippet>18</span>        matches.get_flag(<span class=\"string\">\"derived\"</span>)\n<span data-nosnippet>19</span>    );\n<span data-nosnippet>20</span>\n<span data-nosnippet>21</span>    <span class=\"comment\">// Since DerivedArgs implements FromArgMatches, we can extract it from the unstructured ArgMatches.\n<span data-nosnippet>22</span>    // This is the main benefit of using derived arguments.\n<span data-nosnippet>23</span>    </span><span class=\"kw\">let </span>derived_matches = DerivedArgs::from_arg_matches(<span class=\"kw-2\">&amp;</span>matches)\n<span data-nosnippet>24</span>        .map_err(|err| err.<span class=\"highlight focus\">exit</span>())\n<span data-nosnippet>25</span>        .unwrap();\n<span data-nosnippet>26</span>    <span class=\"macro\">println!</span>(<span class=\"string\">\"Value of derived: {derived_matches:#?}\"</span>);\n<span data-nosnippet>27</span>}</code></pre></div></div><div class=\"scraped-example\" data-locs=\"[[[16,16],&#34;src/04_04_custom_derive/04_04_custom.rs.html#50&#34;,&#34;line 50&#34;],[[32,32],&#34;src/04_04_custom_derive/04_04_custom.rs.html#66&#34;,&#34;line 66&#34;],[[53,53],&#34;src/04_04_custom_derive/04_04_custom.rs.html#87&#34;,&#34;line 87&#34;]]\"><div class=\"scraped-example-title\">examples/tutorial_derive/04_04_custom.rs (<a href=\"src/04_04_custom_derive/04_04_custom.rs.html#50\">line 50</a>)</div><div class=\"example-wrap digits-2\"><pre class=\"rust\"><code><span data-nosnippet>34</span><span class=\"kw\">fn </span>main() {\n<span data-nosnippet>35</span>    <span class=\"kw\">let </span>cli = Cli::parse();\n<span data-nosnippet>36</span>\n<span data-nosnippet>37</span>    <span class=\"comment\">// Let's assume the old version 1.2.3\n<span data-nosnippet>38</span>    </span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>major = <span class=\"number\">1</span>;\n<span data-nosnippet>39</span>    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>minor = <span class=\"number\">2</span>;\n<span data-nosnippet>40</span>    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>patch = <span class=\"number\">3</span>;\n<span data-nosnippet>41</span>\n<span data-nosnippet>42</span>    <span class=\"comment\">// See if --set-ver was used to set the version manually\n<span data-nosnippet>43</span>    </span><span class=\"kw\">let </span>version = <span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(ver) = cli.set_ver.as_deref() {\n<span data-nosnippet>44</span>        <span class=\"kw\">if </span>cli.major || cli.minor || cli.patch {\n<span data-nosnippet>45</span>            <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>cmd = Cli::command();\n<span data-nosnippet>46</span>            cmd.error(\n<span data-nosnippet>47</span>                ErrorKind::ArgumentConflict,\n<span data-nosnippet>48</span>                <span class=\"string\">\"Can't do relative and absolute version change\"</span>,\n<span data-nosnippet>49</span>            )\n<span data-nosnippet>50</span>            .<span class=\"highlight focus\">exit</span>();\n<span data-nosnippet>51</span>        }\n<span data-nosnippet>52</span>        ver.to_string()\n<span data-nosnippet>53</span>    } <span class=\"kw\">else </span>{\n<span data-nosnippet>54</span>        <span class=\"comment\">// Increment the one requested (in a real program, we'd reset the lower numbers)\n<span data-nosnippet>55</span>        </span><span class=\"kw\">let </span>(maj, min, pat) = (cli.major, cli.minor, cli.patch);\n<span data-nosnippet>56</span>        <span class=\"kw\">match </span>(maj, min, pat) {\n<span data-nosnippet>57</span>            (<span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">false</span>) =&gt; major += <span class=\"number\">1</span>,\n<span data-nosnippet>58</span>            (<span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>) =&gt; minor += <span class=\"number\">1</span>,\n<span data-nosnippet>59</span>            (<span class=\"bool-val\">false</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>) =&gt; patch += <span class=\"number\">1</span>,\n<span data-nosnippet>60</span>            <span class=\"kw\">_ </span>=&gt; {\n<span data-nosnippet>61</span>                <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>cmd = Cli::command();\n<span data-nosnippet>62</span>                cmd.error(\n<span data-nosnippet>63</span>                    ErrorKind::ArgumentConflict,\n<span data-nosnippet>64</span>                    <span class=\"string\">\"Can only modify one version field\"</span>,\n<span data-nosnippet>65</span>                )\n<span data-nosnippet>66</span>                .<span class=\"highlight\">exit</span>();\n<span data-nosnippet>67</span>            }\n<span data-nosnippet>68</span>        };\n<span data-nosnippet>69</span>        <span class=\"macro\">format!</span>(<span class=\"string\">\"{major}.{minor}.{patch}\"</span>)\n<span data-nosnippet>70</span>    };\n<span data-nosnippet>71</span>\n<span data-nosnippet>72</span>    <span class=\"macro\">println!</span>(<span class=\"string\">\"Version: {version}\"</span>);\n<span data-nosnippet>73</span>\n<span data-nosnippet>74</span>    <span class=\"comment\">// Check for usage of -c\n<span data-nosnippet>75</span>    </span><span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(config) = cli.config.as_deref() {\n<span data-nosnippet>76</span>        <span class=\"kw\">let </span>input = cli\n<span data-nosnippet>77</span>            .input_file\n<span data-nosnippet>78</span>            .as_deref()\n<span data-nosnippet>79</span>            <span class=\"comment\">// 'or' is preferred to 'or_else' here since `Option::as_deref` is 'const'\n<span data-nosnippet>80</span>            </span>.or(cli.spec_in.as_deref())\n<span data-nosnippet>81</span>            .unwrap_or_else(|| {\n<span data-nosnippet>82</span>                <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>cmd = Cli::command();\n<span data-nosnippet>83</span>                cmd.error(\n<span data-nosnippet>84</span>                    ErrorKind::MissingRequiredArgument,\n<span data-nosnippet>85</span>                    <span class=\"string\">\"INPUT_FILE or --spec-in is required when using --config\"</span>,\n<span data-nosnippet>86</span>                )\n<span data-nosnippet>87</span>                .<span class=\"highlight\">exit</span>()\n<span data-nosnippet>88</span>            });\n<span data-nosnippet>89</span>        <span class=\"macro\">println!</span>(<span class=\"string\">\"Doing work using input {input} and config {config}\"</span>);\n<span data-nosnippet>90</span>    }\n<span data-nosnippet>91</span>}</code></pre></div></div></div></details></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.print\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#268\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.print\" class=\"fn\">print</a>(&amp;self) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/std/io/error/struct.Error.html\" title=\"struct std::io::error::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Prints formatted and colored error to <code>stdout</code> or <code>stderr</code> according to its error kind</p>\n<h5 id=\"example-2\"><a class=\"doc-anchor\" href=\"#example-2\">§</a>Example</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>clap::Command;\n\n<span class=\"kw\">match </span>Command::new(<span class=\"string\">\"Command\"</span>).try_get_matches() {\n    <span class=\"prelude-val\">Ok</span>(matches) =&gt; {\n        <span class=\"comment\">// do_something\n    </span>},\n    <span class=\"prelude-val\">Err</span>(err) =&gt; {\n        err.print().expect(<span class=\"string\">\"Error writing Error\"</span>);\n        <span class=\"comment\">// do_something\n    </span>},\n};</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.render\" class=\"method\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#300\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.render\" class=\"fn\">render</a>(&amp;self) -&gt; <a class=\"struct\" href=\"clap/builder/struct.StyledStr.html\" title=\"struct clap::builder::StyledStr\">StyledStr</a></h4></section></summary><div class=\"docblock\"><p>Render the error message to a <a href=\"clap/builder/struct.StyledStr.html\" title=\"struct clap::builder::StyledStr\"><code>StyledStr</code></a>.</p>\n<h5 id=\"example-3\"><a class=\"doc-anchor\" href=\"#example-3\">§</a>Example</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>clap::Command;\n\n<span class=\"kw\">match </span>Command::new(<span class=\"string\">\"Command\"</span>).try_get_matches() {\n    <span class=\"prelude-val\">Ok</span>(matches) =&gt; {\n        <span class=\"comment\">// do_something\n    </span>},\n    <span class=\"prelude-val\">Err</span>(err) =&gt; {\n        <span class=\"kw\">let </span>err = err.render();\n        <span class=\"macro\">println!</span>(<span class=\"string\">\"{err}\"</span>);\n        <span class=\"comment\">// do_something\n    </span>},\n};</code></pre></div></div></details></div></details>",0,"clap::Error"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Error-for-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#836\">Source</a><a href=\"#impl-Error-for-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html\" title=\"trait core::error::Error\">Error</a> for <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.source\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#838\">Source</a><a href=\"#method.source\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.source\" class=\"fn\">source</a>(&amp;self) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;&amp;(dyn <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html\" title=\"trait core::error::Error\">Error</a> + 'static)&gt;</h4></section></summary><div class='docblock'>Returns the lower-level source of this error, if any. <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.source\">Read more</a></div></details><details class=\"toggle method-toggle deprecated\" open><summary><section id=\"method.description\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"https://doc.rust-lang.org/nightly/src/core/error.rs.html#137\">Source</a></span><a href=\"#method.description\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.description\" class=\"fn\">description</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"https://doc.rust-lang.org/nightly/std/primitive.str.html\">str</a></h4></section></summary><span class=\"item-info\"><div class=\"stab deprecated\"><span class=\"emoji\">👎</span><span>Deprecated since 1.42.0: use the Display impl or to_string()</span></div></span><div class='docblock'> <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.description\">Read more</a></div></details><details class=\"toggle method-toggle deprecated\" open><summary><section id=\"method.cause\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"https://doc.rust-lang.org/nightly/src/core/error.rs.html#147\">Source</a></span><a href=\"#method.cause\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.cause\" class=\"fn\">cause</a>(&amp;self) -&gt; <a class=\"enum\" href=\"https://doc.rust-lang.org/nightly/core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;&amp;dyn <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html\" title=\"trait core::error::Error\">Error</a>&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab deprecated\"><span class=\"emoji\">👎</span><span>Deprecated since 1.33.0: replaced by Error::source, which can support downcasting</span></div></span></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.provide\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://doc.rust-lang.org/nightly/src/core/error.rs.html#260\">Source</a><a href=\"#method.provide\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.provide\" class=\"fn\">provide</a>&lt;'a&gt;(&amp;'a self, request: &amp;mut <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/error/struct.Request.html\" title=\"struct core::error::Request\">Request</a>&lt;'a&gt;)</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>error_generic_member_access</code>)</span></div></span><div class='docblock'>Provides type-based access to context intended for error reports. <a href=\"https://doc.rust-lang.org/nightly/core/error/trait.Error.html#method.provide\">Read more</a></div></details></div></details>","Error","clap::Error"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CError%3E-for-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#818\">Source</a><a href=\"#impl-From%3CError%3E-for-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/std/io/error/struct.Error.html\" title=\"struct std::io::error::Error\">Error</a>&gt; for <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#819\">Source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(e: <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/std/io/error/struct.Error.html\" title=\"struct std::io::error::Error\">Error</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<Error>","clap::Error"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CError%3E-for-Error%3CF%3E\" class=\"impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#824\">Source</a><a href=\"#impl-From%3CError%3E-for-Error%3CF%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;F&gt; <a class=\"trait\" href=\"https://doc.rust-lang.org/nightly/core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Error.html\" title=\"struct core::fmt::Error\">Error</a>&gt; for <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;<div class=\"where\">where\n    F: <a class=\"trait\" href=\"clap/error/trait.ErrorFormatter.html\" title=\"trait clap::error::ErrorFormatter\">ErrorFormatter</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"https://docs.rs/clap_builder/4.5.57/aarch64-apple-darwin/src/clap_builder/error/mod.rs.html#825\">Source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"https://doc.rust-lang.org/nightly/core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(e: <a class=\"struct\" href=\"https://doc.rust-lang.org/nightly/core/fmt/struct.Error.html\" title=\"struct core::fmt::Error\">Error</a>) -&gt; <a class=\"struct\" href=\"clap/error/struct.Error.html\" title=\"struct clap::error::Error\">Error</a>&lt;F&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<Error>","clap::Error"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[44228]}