//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

RaytracingAccelerationStructure accelStructure : register(t0, space0);
RWTexture2D<float4> outTexture : register(u0, space1);

[numthreads(32, 32, 1)]
void MainCS( uint2 tid : SV_DispatchThreadID )
{
    uint uavW;
    uint uavH;
    outTexture.GetDimensions(uavW, uavH);

    if ( tid.x < uavW && tid.y < uavH )
    {
        float4 background = float4(abs(float2(tid)/float2(uavW, uavH) * 2.0 - 1.0), 0.0, 1.0);
        
        float4 color = background;

        RayQuery<RAY_FLAG_CULL_NON_OPAQUE | RAY_FLAG_SKIP_PROCEDURAL_PRIMITIVES | RAY_FLAG_ACCEPT_FIRST_HIT_AND_END_SEARCH> q;

        RayDesc r;
        r.Origin = float3(0, 0, 0);
        r.Direction = float3( float2(tid)/float2(uavW, uavH) * 2.0 - 1.0, -1.0 );
        r.Direction.y *= -1.0;
        r.TMin = 0.04;
        r.TMax = 100.0;

        q.TraceRayInline( accelStructure, RAY_FLAG_NONE, 0xFF, r );

        while( q.Proceed() );

        if (q.CommittedStatus() != COMMITTED_NOTHING)
        {
            float2 rqbary = q.CommittedTriangleBarycentrics();
            float3 bary = float3(1.0 - rqbary.x + rqbary.y, rqbary.x, rqbary.y);
            color = float4(bary, 1.0);
        }

        outTexture[tid] = color;

    }

}
