//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

#ifndef SHADERPIPELINEBUILDER_HPP
#define SHADERPIPELINEBUILDER_HPP

#include <Metal/Metal.hpp>

#define IR_RUNTIME_METALCPP
#include <metal_irconverter_runtime/metal_irconverter_runtime.h>

#include <string>

template <typename T>
struct RenderPipelineStateWithConfig
{
    MTL::RenderPipelineState* pRenderPipelineState;
    T pipelineConfig;
};

namespace shader_pipeline
{
    MTL::ComputePipelineState* newComputeRTPipeline(const std::string& shaderSearchPath, MTL::Device* pDevice );
    MTL::RenderPipelineState*  newPresentPipeline( const std::string& shaderSearchPath, MTL::Device* pDevice );
}

#endif // SHADERPIPELINEBUILDER_HPP
