#!/usr/bin/env python
# http://oscon.com/oscon2012/public/schedule/detail/24416

# settings.py (by Wesley Chun under Apache2 license)
# http://www.apache.org/licenses/LICENSE-2.0.html
# set variables below and save as settings.py (replaces tweet_auth.py)

# - confidential info for your app
# - all values below are strings
# - in a real app, these should be encrypted
# - in a real app, these should NOT be hardcoded in source
#   (use a database, credential server/proxy, etc.)

###########
# Twitter #
###########
# 1. go to http://dev.twitter.com/apps to create your app
# 2. click/select that app to get the 4 values below on the resulting page
# 3. these values come in pairs and should be assigned as strings below
CONSUMER_KEY = xxx
CONSUMER_SECRET	 = xxx
ACCESS_TOKEN = xxx
ACCESS_TOKEN_SECRET = xxx

##########
# Google #
##########
# 0. Go to http://cloud.google.com/console to create your app/project
# 1. Enable one or more Google APIs in "APIs & auth -> APIs" section
# 2. Go to "APIs & auth -> Credentials" section
# 3. Select "Add credentials -> API key" and create an API key (set below)
# 4. Select "Add credentials -> OAuth2.0 client ID" and create a client ID pair
# 5. Select Client ID once it's been created and grab ID & secret
#    (put those values in CLIENT_ID & CLIENT_SECRET respectively)
# 6. While you're grabbing that pair of values, click "Download JSON"
# 7. Assign saved JSON file to AUTH_FILE variable below
#    (else reauthorize every time you run your app)
# 8. SCOPE needs to include at least Google+
#    (you can add others [space-delimited])
# 9. Use an appropriate HTTP client USER_AGENT (we used the one below)
API_KEY = xxx
CLIENT_ID = xxx
CLIENT_SECRET = xxx
AUTH_FILE = xxx
SCOPE = xxx # 'https://www.googleapis.com/auth/plus.me'
USER_AGENT = 'Python-urllib/2.7'

# - after filling out all the fields, rename to 'settings.py'
